/*
 * Decompiled with CFR 0.152.
 */
package selfservice;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import selfservice.filter.EnsureAccessToIdpFilter;
import selfservice.filter.SabEntitlementsFilter;
import selfservice.filter.VootFilter;
import selfservice.sab.Sab;
import selfservice.service.Csa;
import selfservice.service.VootClient;
import selfservice.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import selfservice.shibboleth.ShibbolethUserDetailService;
import selfservice.shibboleth.mock.MockShibbolethFilter;

@Configuration
@EnableWebSecurity
public class ShibbolethSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethSecurityConfig.class);
    @Autowired
    private Csa csa;
    @Autowired
    private VootClient vootClient;
    @Autowired
    private Sab sab;
    @Value(value="${dashboard.admin}")
    private String dashboardAdmin;
    @Value(value="${dashboard.viewer}")
    private String dashboardViewer;
    @Value(value="${dashboard.super.user}")
    private String dashboardSuperUser;
    @Value(value="${admin.surfconext.idp.sabRole}")
    private String adminSufConextIdpRole;
    @Value(value="${viewer.surfconext.idp.sabRole}")
    private String viewerSurfConextIdpRole;

    @Bean
    @Profile(value={"dev"})
    public FilterRegistrationBean mockShibbolethFilter() {
        FilterRegistrationBean shibFilter = new FilterRegistrationBean();
        shibFilter.setFilter((Filter)new MockShibbolethFilter());
        shibFilter.addUrlPatterns(new String[]{"/*"});
        shibFilter.setOrder(1);
        return shibFilter;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/home", "/forbidden", "/css/**", "/font/**", "/images/**", "/js/**", "/health", "/info"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.logout().invalidateHttpSession(true).deleteCookies(new String[]{"statsToken"}).logoutSuccessHandler((LogoutSuccessHandler)new DashboardLogoutSuccessHandler()).addLogoutHandler((LogoutHandler)new DashboardLogoutHandler()).and()).csrf().disable()).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.csa), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new VootFilter(this.vootClient, this.dashboardAdmin, this.dashboardViewer, this.dashboardSuperUser), ShibbolethPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new SabEntitlementsFilter(this.sab, this.adminSufConextIdpRole, this.viewerSurfConextIdpRole), VootFilter.class).addFilterAfter((Filter)new EnsureAccessToIdpFilter(this.csa), SabEntitlementsFilter.class).authorizeRequests().antMatchers(new String[]{"/identity/**"})).hasRole("DASHBOARD_SUPER_USER").antMatchers(new String[]{"/**"})).hasAnyRole(new String[]{"DASHBOARD_ADMIN", "DASHBOARD_VIEWER", "DASHBOARD_SUPER_USER"}).anyRequest()).authenticated();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOG.info("Configuring AuthenticationManager with a PreAuthenticatedAuthenticationProvider");
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    @Bean
    protected AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }

    private static class DashboardLogoutSuccessHandler
    implements LogoutSuccessHandler {
        private DashboardLogoutSuccessHandler() {
        }

        public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
            response.setStatus(204);
        }
    }

    private static class DashboardLogoutHandler
    implements LogoutHandler {
        private static final Logger LOG = LoggerFactory.getLogger(DashboardLogoutHandler.class);

        private DashboardLogoutHandler() {
        }

        public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
            LOG.debug("Logging out user {}", (Object)authentication);
            Cookie statsToken = new Cookie("statsToken", "");
            statsToken.setMaxAge(0);
            httpServletResponse.addCookie(statsToken);
            SecurityContextHolder.getContext().setAuthentication(null);
            httpServletResponse.setStatus(204);
        }
    }
}

