/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import selfservice.api.rest.GsonHttpMessageConverter;
import selfservice.domain.CoinUser;
import selfservice.domain.Service;
import selfservice.util.AttributeMapFilter;

public class EnrichJson {
    private static final Logger logger = LoggerFactory.getLogger(EnrichJson.class);
    public static final String FILTERED_USER_ATTRIBUTES = "filteredUserAttributes";
    public static final String SUPER_USER = "superUser";
    public static final String DASHBOARD_ADMIN = "dashboardAdmin";
    public static final String STATS_URL = "statsUrl";
    private Map<Class<?>, JsonApplier> mapping = new HashMap();
    private final CoinUser currentUser;
    private JsonElement json;

    private EnrichJson(CoinUser coinUser, String statsUrl) {
        logger.debug("Using {} for user {}", (Object)statsUrl, (Object)coinUser.getDisplayName());
        this.currentUser = coinUser;
        Gson gson = GsonHttpMessageConverter.GSON_BUILDER.create();
        this.mapping.put(CoinUser.class, (coinUserJsonElement, payload) -> {
            JsonObject user = coinUserJsonElement.getAsJsonObject();
            user.addProperty(SUPER_USER, Boolean.valueOf(((CoinUser)payload).isSuperUser()));
            user.addProperty(DASHBOARD_ADMIN, Boolean.valueOf(((CoinUser)payload).isDashboardAdmin()));
            user.addProperty(STATS_URL, statsUrl);
        });
        this.mapping.put(Service.class, (serviceJsonElement, payload) -> {
            Service service = (Service)payload;
            JsonArray filteredUserAttributes = new JsonArray();
            if (service.getArp() != null && !service.getArp().isNoArp() && !service.getArp().isNoAttrArp()) {
                AttributeMapFilter.filterAttributes(service.getArp().getAttributes(), this.currentUser.getAttributeMap()).stream().map(arg_0 -> ((Gson)gson).toJsonTree(arg_0)).forEach(arg_0 -> ((JsonArray)filteredUserAttributes).add(arg_0));
            }
            serviceJsonElement.getAsJsonObject().add(FILTERED_USER_ATTRIBUTES, (JsonElement)filteredUserAttributes);
        });
    }

    public EnrichJson json(JsonElement json) {
        this.json = json;
        return this;
    }

    public static EnrichJson forUser(CoinUser currentUser, String statsUrl) {
        return new EnrichJson(currentUser, statsUrl);
    }

    public void forPayload(Object payload) {
        JsonElement payloadAsJsonElement = this.json.getAsJsonObject().get("payload");
        if (payloadAsJsonElement.isJsonObject()) {
            if (this.mapping.containsKey(payload.getClass())) {
                this.mapping.get(payload.getClass()).apply(payloadAsJsonElement, payload);
            }
        } else if (!payloadAsJsonElement.isJsonPrimitive()) {
            JsonArray jsonArray = payloadAsJsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Class<?> classOfPayloadElement = ((List)payload).get(i).getClass();
                if (!this.mapping.containsKey(classOfPayloadElement)) continue;
                this.mapping.get(classOfPayloadElement).apply(jsonArray.get(i), ((List)payload).get(i));
            }
        }
    }

    private static interface JsonApplier {
        public void apply(JsonElement var1, Object var2);
    }
}

