/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import selfservice.api.rest.BaseController;
import selfservice.api.rest.RestResponse;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.domain.LicenseContactPerson;
import selfservice.sab.Sab;
import selfservice.sab.SabPerson;
import selfservice.service.Csa;
import selfservice.util.SpringSecurity;

@Controller
@RequestMapping(value={"/idp"}, produces={"application/json"})
public class IdpController
extends BaseController {
    public static final List<String> INTERESTING_ROLES = Arrays.asList("SURFconextbeheerder", "SURFconextverantwoordelijke");
    @Resource
    private Sab sabClient;
    @Resource
    private Csa csa;

    @RequestMapping(value={"/current/roles"})
    public ResponseEntity<RestResponse> roles(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId) {
        HashMap<String, Collection<SabPerson>> roleAssignments = new HashMap<String, Collection<SabPerson>>();
        Optional<InstitutionIdentityProvider> institutionIdentityProvider = SpringSecurity.getCurrentUser().getByEntityId(idpEntityId);
        if (institutionIdentityProvider.isPresent()) {
            for (String role : INTERESTING_ROLES) {
                Collection<SabPerson> rolesForOrganization = this.sabClient.getPersonsInRoleForOrganization(institutionIdentityProvider.get().getInstitutionId(), role);
                roleAssignments.put(role, rolesForOrganization);
            }
        }
        return new ResponseEntity((Object)this.createRestResponse(roleAssignments), HttpStatus.OK);
    }

    @RequestMapping(value={"/licensecontactpersons"})
    public ResponseEntity<RestResponse> licenseContactPerson(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId) {
        List<LicenseContactPerson> licenseContactPersons = this.csa.licenseContactPersons(idpEntityId);
        return new ResponseEntity((Object)this.createRestResponse(licenseContactPersons), HttpStatus.OK);
    }
}

