/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import selfservice.domain.CoinAuthority;
import selfservice.domain.InstitutionIdentityProvider;

public class CoinUser
implements UserDetails {
    private String uid;
    private String displayName;
    private String schacHomeOrganization;
    private InstitutionIdentityProvider currentIdp;
    private InstitutionIdentityProvider switchedToIdp;
    private List<InstitutionIdentityProvider> institutionIdps = new ArrayList<InstitutionIdentityProvider>();
    private String institutionId;
    private String email;
    private Set<CoinAuthority> grantedAuthorities = new HashSet<CoinAuthority>();
    private Map<String, List<String>> attributeMap = new HashMap<String, List<String>>();

    @JsonIgnore
    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.uid;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSuperUser() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
    }

    public boolean isDashboardAdmin() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
    }

    public boolean isDashboardViewer() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public void setAuthorities(Set<CoinAuthority> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

    public void addAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.add(grantedAuthority);
    }

    public void removeAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.remove(grantedAuthority);
    }

    public boolean hasAuthority(CoinAuthority grantedAuthority) {
        return this.grantedAuthorities.contains(grantedAuthority);
    }

    public List<InstitutionIdentityProvider> getInstitutionIdps() {
        return this.institutionIdps;
    }

    public void addInstitutionIdp(InstitutionIdentityProvider idp) {
        this.institutionIdps.add(idp);
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public InstitutionIdentityProvider getIdp() {
        return this.currentIdp;
    }

    public void setIdp(InstitutionIdentityProvider idp) {
        this.currentIdp = idp;
    }

    public InstitutionIdentityProvider getSwitchedToIdp() {
        return this.switchedToIdp;
    }

    public void setSwitchedToIdp(InstitutionIdentityProvider switchedToIdp) {
        this.switchedToIdp = switchedToIdp;
    }

    public Map<String, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, List<String>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void addAttribute(String key, List<String> value) {
        this.attributeMap.put(key, value);
    }

    public List<CoinAuthority.Authority> getAuthorityEnums() {
        ArrayList<CoinAuthority.Authority> result = new ArrayList<CoinAuthority.Authority>();
        for (CoinAuthority authority : this.grantedAuthorities) {
            result.add(authority.getEnumAuthority());
        }
        return result;
    }

    public Optional<InstitutionIdentityProvider> getByEntityId(String entityId) {
        for (InstitutionIdentityProvider institutionIdentityProvider : this.getInstitutionIdps()) {
            if (!institutionIdentityProvider.getId().equals(entityId)) continue;
            return Optional.of(institutionIdentityProvider);
        }
        return Optional.empty();
    }

    public String toString() {
        return "CoinUser [uid=" + this.uid + ", displayName=" + this.displayName + ", schacHomeOrganization=" + this.schacHomeOrganization + ", idp=" + this.currentIdp + ", institutionIdps=" + this.institutionIdps + ", institutionId=" + this.institutionId + ", email=" + this.email + ", grantedAuthorities=" + new ArrayList<CoinAuthority>(this.grantedAuthorities) + ", attributeMap=" + this.attributeMap + "]";
    }
}

