/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import selfservice.domain.Action;
import selfservice.domain.Category;
import selfservice.domain.CategoryValue;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.domain.LicenseContactPerson;
import selfservice.domain.Service;
import selfservice.domain.Taxonomy;
import selfservice.service.Csa;

public class CsaImpl
implements Csa {
    private String defaultLocale = "en";
    private String accessTokenUri;
    private String clientId;
    private String clientSecret;
    private String spaceDelimitedScopes;
    private String serviceUrl;
    private OAuth2RestTemplate csaService;

    public CsaImpl(String accessTokenUri, String clientId, String clientSecret, String spaceDelimitedScopes, String serviceUrl) {
        this.accessTokenUri = accessTokenUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.spaceDelimitedScopes = spaceDelimitedScopes;
        this.serviceUrl = serviceUrl;
        this.csaService = new OAuth2RestTemplate(this.csaConfiguration());
    }

    private OAuth2ProtectedResourceDetails csaConfiguration() {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setId("dashboard");
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setScope(Arrays.asList(this.spaceDelimitedScopes.split(" ")));
        return details;
    }

    @Override
    public List<Service> getServicesForIdp(String idpEntityId) {
        String url = this.serviceUrl + "/api/protected/idp/services.json?idpEntityId={idpEntityId}&lang={lang}";
        return this.restoreCategoryReferences(Arrays.asList((Object[])this.csaService.getForEntity(url, Service[].class, new Object[]{idpEntityId, this.getLocale()}).getBody()));
    }

    @Override
    public List<InstitutionIdentityProvider> getInstitutionIdentityProviders(String identityProviderId) {
        String url = this.serviceUrl + "/api/protected/identityproviders.json?identityProviderId={identityProviderId}";
        return Arrays.asList((Object[])this.csaService.getForEntity(url, InstitutionIdentityProvider[].class, new Object[]{identityProviderId}).getBody());
    }

    @Override
    public List<InstitutionIdentityProvider> getAllInstitutionIdentityProviders() {
        String url = this.serviceUrl + "/api/protected/all-identityproviders.json";
        return Arrays.asList((Object[])this.csaService.getForEntity(url, InstitutionIdentityProvider[].class, new Object[0]).getBody());
    }

    @Override
    public List<InstitutionIdentityProvider> serviceUsedBy(String spEntityId) {
        String url = this.serviceUrl + "/api/protected/services-usage.json?spEntityId={spEntityId}";
        return Arrays.asList((Object[])this.csaService.getForEntity(url, InstitutionIdentityProvider[].class, new Object[]{spEntityId}).getBody());
    }

    @Override
    public List<Action> getJiraActions(String idpEntityId) {
        String url = this.serviceUrl + "/api/protected/actions.json?idpEntityId={idpEntityId}";
        return Arrays.asList((Object[])this.csaService.getForEntity(url, Action[].class, new Object[]{idpEntityId}).getBody());
    }

    @Override
    public Taxonomy getTaxonomy() {
        Taxonomy taxonomy = (Taxonomy)this.csaService.getForEntity(this.serviceUrl + "/api/public/taxonomy.json?lang={lang}", Taxonomy.class, new Object[]{this.getLocale()}).getBody();
        List<Category> categories = taxonomy.getCategories();
        for (Category category : categories) {
            List<CategoryValue> values = category.getValues();
            for (CategoryValue value : values) {
                value.setCategory(category);
            }
        }
        return taxonomy;
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, long serviceId) {
        String url = this.serviceUrl + "/api/protected/services/{serviceId}.json?idpEntityId={idpEntityId}&lang={lang}";
        Service service = (Service)this.csaService.getForEntity(url, Service.class, new Object[]{serviceId, idpEntityId, this.getLocale()}).getBody();
        service.restoreCategoryReferences();
        return service;
    }

    @Override
    public Action createAction(Action action) {
        String url = this.serviceUrl + "/api/protected/action.json";
        return (Action)this.csaService.postForEntity(url, (Object)action, Action.class, new Object[0]).getBody();
    }

    @Override
    public List<LicenseContactPerson> licenseContactPersons(String idpEntityId) {
        String url = this.serviceUrl + "/api/protected/licensecontactperson.json?identityProviderId={identityProviderId}";
        return Arrays.asList((Object[])this.csaService.getForEntity(url, LicenseContactPerson[].class, new Object[]{idpEntityId}).getBody());
    }

    private List<Service> restoreCategoryReferences(List<Service> services) {
        services.forEach(Service::restoreCategoryReferences);
        return services;
    }

    private String getLocale() {
        HttpServletRequest request;
        Locale locale = null;
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null && (request = sra.getRequest()) != null) {
            locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        }
        return locale != null ? locale.getLanguage() : this.defaultLocale;
    }
}

