/*
 * Decompiled with CFR 0.152.
 */
package selfservice.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import selfservice.domain.CoinAuthority;
import selfservice.domain.NotificationMessage;
import selfservice.domain.Service;
import selfservice.service.Csa;
import selfservice.service.NotificationService;
import selfservice.util.SpringSecurity;

@Component
public class NotificationServiceImpl
implements NotificationService {
    protected static final String FCP_NOTIFICATIONS = "notifications.messages.fcp";
    @Resource
    private Csa csa;

    @Override
    public NotificationMessage getNotifications(String idpId) {
        boolean isFcp;
        NotificationMessage notificationMessage = new NotificationMessage();
        boolean bl = isFcp = this.getAuthorities().contains((Object)CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN) || this.getAuthorities().contains((Object)CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER);
        if (!isFcp) {
            return notificationMessage;
        }
        notificationMessage.addMessageKey(FCP_NOTIFICATIONS);
        List<Service> services = this.csa.getServicesForIdp(idpId);
        ArrayList<Service> notLinkedCSPs = new ArrayList<Service>();
        ArrayList<Service> noLicenseCSPs = new ArrayList<Service>();
        for (Service service : services) {
            if (service.getLicense() != null && !service.isConnected()) {
                notLinkedCSPs.add(service);
                continue;
            }
            if (service.getLicense() != null || !service.isHasCrmLink() || !service.isConnected()) continue;
            noLicenseCSPs.add(service);
        }
        if (!notLinkedCSPs.isEmpty()) {
            notificationMessage.addArguments(notLinkedCSPs);
        }
        if (!noLicenseCSPs.isEmpty()) {
            notificationMessage.addArguments(noLicenseCSPs);
        }
        return notificationMessage;
    }

    protected List<CoinAuthority.Authority> getAuthorities() {
        return SpringSecurity.getCurrentUser().getAuthorityEnums();
    }
}

