/*
 * Decompiled with CFR 0.152.
 */
package selfservice.shibboleth.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String userId = request.getParameter("mockUser");
        if (userId == null) {
            userId = (String)req.getSession().getAttribute("mockShibbolethUser");
        }
        if (userId == null) {
            String redirectTo = request.getParameter("redirectTo");
            String login = IOUtils.toString((InputStream)new ClassPathResource("mockLogin.html").getInputStream());
            if (redirectTo != null) {
                login = login.replaceFirst("@@redirectTo@@", redirectTo);
            }
            response.getWriter().write(login);
        } else {
            req.getSession(true).setAttribute("mockShibbolethUser", (Object)userId);
            SetHeader wrapper = new SetHeader(req);
            wrapper.setHeader("name-id", userId);
            wrapper.setHeader("Shib-uid", userId);
            String idp = "https://idp.surfnet.nl";
            wrapper.setHeader("Shib-Authenticating-Authority", idp);
            wrapper.setHeader("Shib-displayName", "Ben Vonk");
            wrapper.setHeader("X-IDP-ENTITY-ID", idp);
            chain.doFilter((ServletRequest)wrapper, response);
        }
    }

    private static class SetHeader
    extends HttpServletRequestWrapper {
        private final HashMap<String, String> headers = new HashMap();

        public SetHeader(HttpServletRequest request) {
            super(request);
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Enumeration<String> getHeaderNames() {
            ArrayList names = Collections.list(super.getHeaderNames());
            names.addAll(this.headers.keySet());
            return Collections.enumeration(names);
        }

        public String getHeader(String name) {
            if (this.headers.containsKey(name)) {
                return this.headers.get(name);
            }
            return super.getHeader(name);
        }
    }
}

