/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import selfservice.api.rest.BaseController;
import selfservice.api.rest.RestResponse;
import selfservice.domain.Action;
import selfservice.domain.Category;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.domain.JiraTask;
import selfservice.domain.Service;
import selfservice.service.Csa;
import selfservice.util.SpringSecurity;

@Controller
@RequestMapping(value={"/services"}, produces={"application/json"})
public class ServicesController
extends BaseController {
    private static Set<String> IGNORED_ARP_LABELS = ImmutableSet.of((Object)"urn:mace:dir:attribute-def:eduPersonTargetedID");
    @Resource
    private Csa csa;

    @RequestMapping
    public ResponseEntity<RestResponse> index(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId) {
        List<Service> services = this.csa.getServicesForIdp(idpEntityId);
        return new ResponseEntity((Object)this.createRestResponse(services), HttpStatus.OK);
    }

    @RequestMapping(value={"/idps"})
    public ResponseEntity<RestResponse> getConnectedIdps(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam String spEntityId) {
        List<InstitutionIdentityProvider> providers = this.csa.serviceUsedBy(spEntityId);
        return new ResponseEntity((Object)this.createRestResponse(providers), HttpStatus.OK);
    }

    @RequestMapping(value={"/download"})
    public ResponseEntity<RestResponse> download(@RequestParam(value="idpEntityId") String idpEntityId, @RequestParam(value="id[]") List<Long> ids, HttpServletResponse response) {
        List<Service> services = this.csa.getServicesForIdp(idpEntityId);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        rows.add(new String[]{"id", "name", "description", "app-url", "wiki-url", "support-mail", "connected", "license", "licenseStatus", "categories", "spEntityId", "spName", "publishedInEdugain", "normenkaderPresent", "normenkaderUrl", "singleTenant"});
        for (Long id : ids) {
            Service service = this.getServiceById(services, id);
            rows.add(new String[]{String.valueOf(service.getId()), service.getName(), service.getDescription(), service.getAppUrl(), service.getWikiUrl(), service.getSupportMail(), String.valueOf(service.isConnected()), service.getLicense() != null ? service.getLicense().toString() : null, service.getLicenseStatus(), service.getCategories().stream().map(Category::getName).collect(Collectors.joining()), service.getSpEntityId(), service.getSpName(), String.valueOf(service.isPublishedInEdugain()), String.valueOf(service.isNormenkaderPresent()), service.getNormenkaderUrl(), String.valueOf(service.isExampleSingleTenant())});
        }
        response.setHeader("Content-Disposition", String.format("attachment; filename=service-overview.csv", new Object[0]));
        try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            writer.writeAll(rows);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    private Service getServiceById(List<Service> services, Long id) {
        for (Service service : services) {
            if (service.getId() != id.longValue()) continue;
            return service;
        }
        return null;
    }

    @RequestMapping(value={"/id/{id}"})
    public ResponseEntity<RestResponse> get(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @PathVariable long id) {
        Service service = this.csa.getServiceForIdp(idpEntityId, id);
        for (String label : IGNORED_ARP_LABELS) {
            if (service.getArp() == null) continue;
            service.getArp().getAttributes().remove(label);
        }
        return new ResponseEntity((Object)this.createRestResponse(service), HttpStatus.OK);
    }

    @RequestMapping(value={"/id/{id}/connect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse> connect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId", required=true) String spEntityId, @PathVariable String id) {
        if (!this.createAction(idpEntityId, comments, spEntityId, JiraTask.Type.LINKREQUEST)) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/id/{id}/disconnect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse> disconnect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId", required=true) String spEntityId, @PathVariable String id) {
        if (!this.createAction(idpEntityId, comments, spEntityId, JiraTask.Type.UNLINKREQUEST)) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    private boolean createAction(String idpEntityId, String comments, String spEntityId, JiraTask.Type jiraType) {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || currentUser.isDashboardViewer()) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)currentUser.getIdp().getInstitutionId())) {
            return false;
        }
        Action action = new Action();
        action.setUserId(currentUser.getUid());
        action.setUserEmail(currentUser.getEmail());
        action.setUserName(currentUser.getDisplayName());
        action.setType(jiraType);
        action.setBody(comments);
        action.setIdpId(idpEntityId);
        action.setSpId(spEntityId);
        action.setInstitutionId(currentUser.getIdp().getInstitutionId());
        this.csa.createAction(action);
        return true;
    }
}

