/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import selfservice.api.rest.BaseController;
import selfservice.api.rest.RestResponse;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.service.Csa;
import selfservice.util.SpringSecurity;

@Controller
@RequestMapping(value={"/users"}, produces={"application/json"})
public class UsersController
extends BaseController {
    @Resource
    private Csa csa;

    @RequestMapping(value={"/me"})
    public ResponseEntity<RestResponse> me() {
        return new ResponseEntity((Object)this.createRestResponse(SpringSecurity.getCurrentUser()), HttpStatus.OK);
    }

    @RequestMapping(value={"/super/idps"})
    public ResponseEntity<RestResponse> idps() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        List<InstitutionIdentityProvider> idps = this.csa.getAllInstitutionIdentityProviders();
        Collections.sort(idps, (lh, rh) -> lh.getName().compareTo(rh.getName()));
        List<String> roles = Arrays.asList(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER.name(), CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN.name());
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("idps", idps);
        payload.put("roles", roles);
        return new ResponseEntity((Object)this.createRestResponse(payload), HttpStatus.OK);
    }

    @RequestMapping(value={"/me/switch-to-idp"})
    public ResponseEntity<RestResponse> currentIdp(@RequestParam(value="idpId", required=false) String switchToIdp, @RequestParam(value="role", required=false) String role, HttpServletResponse response) {
        SpringSecurity.setSwitchedToIdp(this.csa, switchToIdp, role);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

