/*
 * Decompiled with CFR 0.152.
 */
package selfservice.domain;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import selfservice.domain.CategoryValue;

public class Category
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private List<CategoryValue> values = new ArrayList<CategoryValue>();

    public Category() {
    }

    public Category(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CategoryValue> getValues() {
        return this.values;
    }

    public void setValues(List<CategoryValue> values) {
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public void addCategoryValue(CategoryValue value) {
        this.values.add(value);
    }

    @JsonIgnore
    public boolean containsValue(String value) {
        return this.values.stream().anyMatch(cv -> cv.getValue().equals(value));
    }

    @JsonIgnore
    public boolean isUsedFacetValues() {
        return this.values.stream().anyMatch(cv -> cv.getCount() > 0);
    }

    public String toString() {
        return MoreObjects.toStringHelper(Category.class).add("name", (Object)this.name).add("values", this.values).toString();
    }
}

