/*
 * Decompiled with CFR 0.152.
 */
package selfservice.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.GenericFilterBean;
import selfservice.service.Csa;
import selfservice.util.SpringSecurity;

public class EnsureAccessToIdpFilter
extends GenericFilterBean {
    private Csa csa;

    public EnsureAccessToIdpFilter(Csa csa) {
        this.csa = csa;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String idpEntityId = req.getHeader("X-IDP-ENTITY-ID");
        if (idpEntityId == null) {
            idpEntityId = request.getParameter("idpEntityId");
        }
        if (!req.getRequestURI().contains("/users/me")) {
            SpringSecurity.ensureAccess(this.csa, idpEntityId);
        }
        chain.doFilter(request, response);
    }
}

