/*
 * Decompiled with CFR 0.152.
 */
package selfservice.shibboleth;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.service.Csa;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Splitter shibHeaderValueSplitter = Splitter.on((char)';').omitEmptyStrings();
    public static final Map<String, String> shibHeaders = ImmutableMap.builder().put((Object)"urn:mace:dir:attribute-def:uid", (Object)"Shib-uid").put((Object)"urn:mace:dir:attribute-def:sn", (Object)"Shib-surName").put((Object)"urn:mace:dir:attribute-def:givenName", (Object)"Shib-givenName").put((Object)"urn:mace:dir:attribute-def:cn", (Object)"Shib-commonName").put((Object)"urn:mace:dir:attribute-def:displayName", (Object)"Shib-displayName").put((Object)"urn:mace:dir:attribute-def:mail", (Object)"Shib-email").put((Object)"urn:mace:dir:attribute-def:eduPersonAffiliation", (Object)"Shib-eduPersonAffiliation").put((Object)"urn:mace:dir:attribute-def:eduPersonEntitlement", (Object)"Shib-eduPersonEntitlement").put((Object)"urn:mace:dir:attribute-def:eduPersonPrincipalName", (Object)"Shib-eduPersonPN").put((Object)"urn:mace:dir:attribute-def:preferredLanguage", (Object)"Shib-preferredLanguage").put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganization", (Object)"Shib-homeOrg").put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganizationType", (Object)"Shib-schacHomeOrganizationType").put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonHomeOrganization", (Object)"Shib-nlEduPersonHomeOrganization").put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonStudyBranch", (Object)"Shib-nlEduPersonStudyBranch").put((Object)"urn:mace:surffederatie.nl:attribute-def:nlStudielinkNummer", (Object)"Shib-nlStudielinkNummer").put((Object)"urn:mace:surffederatie.nl:attribute-def:nlDigitalAuthorIdentifier", (Object)"Shib-nlDigitalAuthorIdentifier").put((Object)"urn:mace:surffederatie_nl:attribute-def:nlEduPersonOrgUnit", (Object)"Shib-nlEduPersonOrgUnit").put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.1", (Object)"Shib-userStatus").put((Object)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (Object)"Shib-accountstatus").put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.2", (Object)"Shib-voName").put((Object)"urn:oid:1.3.6.1.4.1.5923.1.5.1.1", (Object)"Shib-memberOf").build();
    private final Csa csaClient;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, Csa csaClient) {
        this.setAuthenticationManager(authenticationManager);
        this.csaClient = csaClient;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = this.getFirstShibHeaderValue("name-id", request).orElseThrow(() -> new IllegalArgumentException("Missing name-id Shibboleth header"));
        String idpId = this.getFirstShibHeaderValue("Shib-Authenticating-Authority", request).orElseThrow(() -> new IllegalArgumentException("Missing Shib-Authenticating-Authority Shibboleth header"));
        CoinUser coinUser = new CoinUser();
        coinUser.setUid(uid);
        coinUser.setDisplayName(this.getFirstShibHeaderValue("Shib-displayName", request).orElse(null));
        coinUser.setEmail(this.getFirstShibHeaderValue("Shib-email", request).orElse(null));
        coinUser.setSchacHomeOrganization(this.getFirstShibHeaderValue("Shib-homeOrg", request).orElse(null));
        Map<String, List<String>> attributes = shibHeaders.values().stream().filter(h -> StringUtils.hasText((String)request.getHeader(h))).collect(Collectors.toMap(h -> h, h -> this.getShibHeaderValues((String)h, request)));
        coinUser.setAttributeMap(attributes);
        List<InstitutionIdentityProvider> institutionIdentityProviders = this.csaClient.getInstitutionIdentityProviders(idpId);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(institutionIdentityProviders) ? 1 : 0) != 0, (Object)("Csa#getInstitutionIdentityProviders('" + idpId + "') returned zero result"));
        if (institutionIdentityProviders.size() == 1) {
            InstitutionIdentityProvider idp = institutionIdentityProviders.get(0);
            coinUser.setIdp(idp);
            coinUser.addInstitutionIdp(idp);
        } else {
            coinUser.setIdp(this.getCurrentIdp(idpId, institutionIdentityProviders));
            coinUser.getInstitutionIdps().addAll(institutionIdentityProviders);
            Collections.sort(coinUser.getInstitutionIdps(), (lh, rh) -> lh.getName().compareTo(rh.getName()));
        }
        return coinUser;
    }

    private Optional<String> getFirstShibHeaderValue(String name, HttpServletRequest request) {
        return this.getShibHeaderValues(name, request).stream().findFirst();
    }

    private List<String> getShibHeaderValues(String name, HttpServletRequest request) {
        String headerValue = request.getHeader(name);
        if (headerValue == null) {
            return Collections.emptyList();
        }
        return shibHeaderValueSplitter.splitToList((CharSequence)headerValue);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private InstitutionIdentityProvider getCurrentIdp(String idpId, List<InstitutionIdentityProvider> institutionIdentityProviders) {
        return institutionIdentityProviders.stream().filter(provider -> provider.getId().equals(idpId)).findFirst().orElseThrow(() -> new IllegalArgumentException("The Idp('" + idpId + "') is not present in the list of Idp's returned by the CsaClient"));
    }
}

