/*
 * Decompiled with CFR 0.152.
 */
package selfservice.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import selfservice.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;

public class AttributeMapFilter {
    private static List<String> valuesToShow(List<String> filters, List<String> rawValues) {
        if (filters.isEmpty()) {
            return rawValues;
        }
        Collection patterns = filters.stream().map(filter -> Pattern.compile(filter.replaceAll("\\*", ".*"))).collect(Collectors.toList());
        return rawValues.stream().filter(value -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)value).matches())).collect(Collectors.toList());
    }

    public static Collection<ServiceAttribute> filterAttributes(Map<String, List<String>> serviceAttributes, Map<String, List<String>> userAttributes) {
        Function<ServiceAttribute, List> userValues = serviceAttribute -> {
            String shibHeader = ShibbolethPreAuthenticatedProcessingFilter.shibHeaders.get(serviceAttribute.getName());
            return Optional.ofNullable(userAttributes.get(shibHeader)).map(v -> AttributeMapFilter.valuesToShow(serviceAttribute.getFilters(), v)).orElse(Collections.emptyList());
        };
        return serviceAttributes.entrySet().stream().map(entry -> new ServiceAttribute((String)entry.getKey(), (List)entry.getValue())).map(serviceAttribute -> {
            serviceAttribute.addUserValues((List)userValues.apply((ServiceAttribute)serviceAttribute));
            return serviceAttribute;
        }).collect(Collectors.toList());
    }

    public static class ServiceAttribute {
        private final String name;
        private final List<String> filters;
        private final List<String> userValues;

        public ServiceAttribute(String name, List<String> filters) {
            this.name = name;
            this.filters = filters;
            this.userValues = new ArrayList<String>();
        }

        public ServiceAttribute(String name, String ... filters) {
            this(name, Arrays.asList(filters));
        }

        public String getName() {
            return this.name;
        }

        public List<String> getFilters() {
            return this.filters;
        }

        public List<String> getUserValues() {
            return this.userValues;
        }

        public void addUserValues(String ... userValues) {
            this.addUserValues(Arrays.asList(userValues));
        }

        public void addUserValues(List<String> userValues) {
            this.userValues.addAll(userValues);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceAttribute that = (ServiceAttribute)o;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.userValues != null ? !this.userValues.equals(that.userValues) : that.userValues != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.userValues != null ? this.userValues.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ServiceAttribute{name='" + this.name + '\'' + ", filters=" + this.filters + ", userValues=" + this.userValues + '}';
        }
    }
}

