/*
 * Decompiled with CFR 0.152.
 */
package selfservice.util;

import java.util.Collections;
import java.util.HashSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.InstitutionIdentityProvider;
import selfservice.service.Csa;

public class SpringSecurity {
    private static InstitutionIdentityProvider impersonatedIdentityProvider;

    public static CoinUser getCurrentUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return new CoinUser();
        }
        Object principal = auth.getPrincipal();
        if (principal != null && principal instanceof CoinUser) {
            return (CoinUser)principal;
        }
        return new CoinUser();
    }

    public static boolean isFullyAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof CoinUser;
    }

    public static InstitutionIdentityProvider getImpersonatedIdentityProvider() {
        return impersonatedIdentityProvider;
    }

    public static void setImpersonatedIdentityProvider(InstitutionIdentityProvider impersonatedIdentityProvider) {
        SpringSecurity.impersonatedIdentityProvider = impersonatedIdentityProvider;
    }

    public static void ensureAccess(Csa csa, String idpId) {
        SpringSecurity.validateIdp(SpringSecurity.getIdpFromId(csa, idpId));
    }

    public static void setSwitchedToIdp(Csa csa, String idpId, String role) {
        InstitutionIdentityProvider idp = idpId != null ? SpringSecurity.validateIdp(SpringSecurity.getIdpFromId(csa, idpId)) : null;
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (idp == null) {
            currentUser.setAuthorities(new HashSet<CoinAuthority>(Collections.singleton(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER))));
        } else if (!role.isEmpty()) {
            currentUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.valueOf(role)));
        }
        SpringSecurity.getCurrentUser().setSwitchedToIdp(idp);
    }

    public static InstitutionIdentityProvider validateIdp(InstitutionIdentityProvider idp) {
        if (SpringSecurity.getCurrentUser().isSuperUser()) {
            return idp;
        }
        return SpringSecurity.getCurrentUser().getInstitutionIdps().stream().filter(provider -> provider.getId().equals(idp.getId())).findFirst().orElseThrow(() -> new SecurityException(idp.getId() + " is unknown for " + SpringSecurity.getCurrentUser().getUsername()));
    }

    public static InstitutionIdentityProvider getIdpFromId(Csa csa, String idp) {
        return csa.getAllInstitutionIdentityProviders().stream().filter(identityProvider -> identityProvider.getId().equalsIgnoreCase(idp)).findFirst().orElseThrow(() -> new SecurityException(idp + " does not exist"));
    }
}

