/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.service;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import nl.surfnet.coin.shared.domain.ErrorMail;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class ErrorMessageMailer {
    private static final Logger logger = Logger.getLogger(ErrorMessageMailer.class);
    private static final String FROM_ADDRESS = "noreply@surfnet.nl";
    private static final String MESSAGE_SUBJECT = "[SURFconext][{0}][{1}] {2}";
    public static final String MAIL_TEMPLATE = "exception_message_html.txt";
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private String errorMailTo;
    @Autowired
    private JavaMailSender mailSender;

    public boolean sendErrorMail(ErrorMail errorMail) {
        if (!this.isActive()) {
            return false;
        }
        try {
            String template = this.getTemplate(MAIL_TEMPLATE);
            if (!StringUtils.hasText((String)template)) {
                logger.debug((Object)"Error mail template has no content");
                return false;
            }
            MimeMessageHelper helper = this.createMessage();
            helper = this.fillAddressDetails(helper);
            helper = this.addSubject(helper, errorMail);
            helper = this.addBody(helper, template, errorMail);
            this.mailSender.send(helper.getMimeMessage());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Tried to send error mail, but the mail itself failed", (Throwable)e);
            return false;
        }
    }

    private MimeMessageHelper createMessage() {
        MimeMessage message = this.mailSender.createMimeMessage();
        return new MimeMessageHelper(message, "UTF-8");
    }

    private MimeMessageHelper fillAddressDetails(MimeMessageHelper helper) throws MessagingException {
        helper.setFrom(FROM_ADDRESS);
        helper.setTo(this.errorMailTo);
        return helper;
    }

    private MimeMessageHelper addSubject(MimeMessageHelper helper, ErrorMail errorMail) throws MessagingException {
        String subject = MessageFormat.format(MESSAGE_SUBJECT, errorMail.getComponent(), errorMail.getServer(), errorMail.getShortMessage());
        helper.setSubject(subject);
        return helper;
    }

    private MimeMessageHelper addBody(MimeMessageHelper helper, String template, ErrorMail errorMail) throws MessagingException {
        DateTime dateTime = new DateTime();
        DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)DATE_FORMAT);
        DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)TIME_FORMAT);
        String date = dateFormatter.print((ReadableInstant)dateTime);
        String time = timeFormatter.print((ReadableInstant)dateTime);
        String body = MessageFormat.format(template, date, time, errorMail.getServer(), errorMail.getComponent(), errorMail.getUserId(), errorMail.getIdp(), errorMail.getSp(), errorMail.getMessage(), errorMail.getLocation(), errorMail.getDetails());
        helper.setText(body, true);
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTemplate(String templateName) throws IOException {
        InputStream input = null;
        try {
            input = new ClassPathResource("mailtemplates/" + templateName).getInputStream();
            String string = input == null ? "" : IOUtils.toString((InputStream)input);
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setErrorMailTo(String errorMailTo) {
        this.errorMailTo = errorMailTo;
    }

    private boolean isActive() {
        return StringUtils.hasText((String)this.errorMailTo);
    }
}

