/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shared.service;

import org.apache.log4j.Logger;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/**
 * Mock JavaMailSender
 */
public class MockJavaMailSender extends JavaMailSenderImpl {
  private static final Logger logger = Logger.getLogger(MockJavaMailSender.class);

  @Override
  public void send(MimeMessage mimeMessage) throws MailException {
    try {
      String body = mimeMessage.getContent().toString();
      logger.info(
              "Subject: " + mimeMessage.getSubject() + "\n" +
              "Message: " + body);
    } catch (Exception e) {
      logger.error("Something went wrong", e);
    }
  }
}
