/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.log.diagnostics;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.CyclicBufferAppender;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MemoryAppender
extends CyclicBufferAppender<ILoggingEvent> {
    public static final String MDC_DISCRIMINATOR_FIELD = "nl.surfnet.coin.shared.log.diagnostics.SESSION_DISCRIMINATOR";
    public static final String MEMORY_LOGGER = "MEMORYLOGGER";
    public static final String DEFAULT_DUMP_APPENDER = "DUMPAPPENDER";
    private String dumpAppenderName = "DUMPAPPENDER";

    public void setDumpAppender(String dumpAppenderName) {
        this.dumpAppenderName = dumpAppenderName;
    }

    protected Appender<ILoggingEvent> getDumpAppender() {
        Logger rl = (Logger)LoggerFactory.getLogger((String)MEMORY_LOGGER);
        Appender appender = rl.getAppender(this.dumpAppenderName);
        Assert.notNull((Object)appender, (String)("Configured dumpAppender ('" + this.dumpAppenderName + "') cannot be found"));
        return appender;
    }

    public void dump(String discriminator) {
        Appender<ILoggingEvent> dumpAppender = this.getDumpAppender();
        if (dumpAppender == null) {
            return;
        }
        if (discriminator == null) {
            throw new IllegalArgumentException("Discriminator cannot be null");
        }
        List<ILoggingEvent> eventsToDump = this.getBuffer(discriminator);
        for (ILoggingEvent event : eventsToDump) {
            dumpAppender.doAppend((Object)event);
        }
    }

    public void dumpExternal(List<ILoggingEvent> events) {
        if (events == null) {
            return;
        }
        Appender<ILoggingEvent> dumpAppender = this.getDumpAppender();
        for (ILoggingEvent event : events) {
            dumpAppender.doAppend((Object)event);
        }
    }

    public List<ILoggingEvent> getBuffer(String discriminator) {
        int length = this.getLength();
        ArrayList<ILoggingEvent> events = new ArrayList<ILoggingEvent>(length);
        for (int i = 0; i < length; ++i) {
            ILoggingEvent loggingEvent = (ILoggingEvent)this.get(i);
            if (!discriminator.equals(loggingEvent.getMDCPropertyMap().get(MDC_DISCRIMINATOR_FIELD))) continue;
            events.add(loggingEvent);
        }
        return events;
    }
}

