/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import nl.surfnet.coin.shared.filter.DelegatingServletOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger REQUEST_LOG = LoggerFactory.getLogger((String)"nl.surfnet.coin.request");
    private static final Logger RESPONSE_LOG = LoggerFactory.getLogger((String)"nl.surfnet.coin.response");
    public static final String REQUEST_ID_ATTR = "nl.surfnet.coin.shared.filter.LoggingFilter.requestId";
    public static final String OUTPUT_STREAM_COPY_ATTR = "nl.surfnet.coin.shared.filter.LoggingFilter.outputStreamCopy";
    private final Object lock = new Object();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestId;
        ByteArrayOutputStream outputStreamCopy = new ByteArrayOutputStream();
        MemorizingResponseWrapper wrappedResponse = new MemorizingResponseWrapper((HttpServletResponse)response, outputStreamCopy);
        Object object = this.lock;
        synchronized (object) {
            requestId = this.generateRequestId();
        }
        request.setAttribute(REQUEST_ID_ATTR, (Object)requestId);
        request.setAttribute(OUTPUT_STREAM_COPY_ATTR, (Object)outputStreamCopy);
        this.preHandle((HttpServletRequest)request, requestId);
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
            this.postHandle(request, (HttpServletResponse)wrappedResponse, null);
        }
        catch (IOException ioe) {
            this.postHandle(request, (HttpServletResponse)wrappedResponse, ioe);
            throw ioe;
        }
        catch (ServletException se) {
            this.postHandle(request, (HttpServletResponse)wrappedResponse, (Exception)((Object)se));
            throw se;
        }
        catch (RuntimeException rte) {
            this.postHandle(request, (HttpServletResponse)wrappedResponse, rte);
            throw rte;
        }
    }

    protected String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    public void destroy() {
    }

    private void preHandle(HttpServletRequest request, String requestId) {
        if (REQUEST_LOG.isDebugEnabled()) {
            REQUEST_LOG.debug("{} {} {}?{}", new Object[]{requestId, request.getMethod(), request.getRequestURL(), request.getQueryString()});
            if (REQUEST_LOG.isTraceEnabled()) {
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    Enumeration headerValues = request.getHeaders(headerName);
                    while (headerValues.hasMoreElements()) {
                        Object value = headerValues.nextElement();
                        REQUEST_LOG.trace("{} Header: {}: {}", new Object[]{requestId, headerName, value});
                    }
                }
            }
        }
    }

    private void postHandle(ServletRequest request, HttpServletResponse response, Exception e) {
        String requestId;
        String responseData = ((ByteArrayOutputStream)request.getAttribute(OUTPUT_STREAM_COPY_ATTR)).toString();
        MemorizingResponseWrapper responseWrapper = (MemorizingResponseWrapper)response;
        if (RESPONSE_LOG.isDebugEnabled()) {
            requestId = (String)request.getAttribute(REQUEST_ID_ATTR);
            RESPONSE_LOG.debug("{} Response status: {}", (Object)requestId, (Object)responseWrapper.getStatus());
            if (RESPONSE_LOG.isTraceEnabled()) {
                RESPONSE_LOG.trace("{} Response data: {}", (Object)requestId, (Object)responseData);
            }
        }
        if (e != null) {
            requestId = (String)request.getAttribute(REQUEST_ID_ATTR);
            RESPONSE_LOG.info("Exception in request {}: {}", (Object)requestId, (Object)e.getMessage());
        }
    }

    public static class MemorizingResponseWrapper
    extends HttpServletResponseWrapper {
        private final OutputStream outputStream;
        private String status;

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.status = String.valueOf(sc);
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.status = sc + " " + sm;
        }

        public void sendError(int sc) throws IOException {
            super.sendError(sc);
            this.status = String.valueOf(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            super.sendError(sc, msg);
            this.status = sc + " " + msg;
        }

        public MemorizingResponseWrapper(HttpServletResponse response, OutputStream outputStream) {
            super(response);
            this.outputStream = outputStream;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new DelegatingServletOutputStream((OutputStream)new TeeOutputStream((OutputStream)super.getOutputStream(), this.outputStream));
        }

        public String getStatus() {
            return this.status;
        }
    }
}

