/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.log;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import nl.surfnet.coin.shared.log.ApiCallLog;
import nl.surfnet.coin.shared.log.ApiCallLogService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ApiCallLogServiceImpl
implements ApiCallLogService {
    private JdbcTemplate jdbcTemplate;

    public ApiCallLogServiceImpl(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public ApiCallLogServiceImpl(JdbcTemplate template) {
        this.jdbcTemplate = template;
    }

    @Override
    public void saveApiCallLog(ApiCallLog log) {
        Object[] args = new Object[]{log.getUserId(), log.getSpEntityId(), log.getIpAddress(), log.getApiVersion(), log.getResourceUrl(), log.getConsumerKey()};
        this.jdbcTemplate.update("INSERT INTO api_call_log (user_id, spentity_id, ip_address, api_version, resource_url, consumer_key) VALUES  (?, ?, ?, ?, ?, ?)", args);
    }

    @Override
    public List<ApiCallLog> findApiCallLog(String serviceProvider) {
        return this.jdbcTemplate.query("select user_id, spentity_id, ip_address, api_version, resource_url, consumer_key, log_timestamp from api_call_log where spentity_id = ?", (Object[])new String[]{serviceProvider}, (RowMapper)new RowMapper<ApiCallLog>(){

            public ApiCallLog mapRow(ResultSet rs, int rowNum) throws SQLException {
                ApiCallLog log = new ApiCallLog();
                log.setApiVersion(rs.getString("api_version"));
                log.setConsumerKey(rs.getString("consumer_key"));
                log.setIpAddress(rs.getString("ip_address"));
                log.setResourceUrl(rs.getString("resource_url"));
                log.setSpEntityId(rs.getString("spentity_id"));
                log.setTimestamp(rs.getDate("log_timestamp"));
                log.setUserId(rs.getString("user_id"));
                return log;
            }
        });
    }

    @Override
    public List<String> findServiceProviders() {
        return this.jdbcTemplate.query("select distinct spentity_id from api_call_log;", (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("spentity_id");
            }
        });
    }
}

