/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.log.diagnostics;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import nl.surfnet.coin.shared.log.diagnostics.MemoryAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DiagnosticsLoggerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticsLoggerFilter.class);
    public static final String MEMORY_APPENDER = "MEMORYAPPENDER";
    public static final String MEMORY_LOGGER = "MEMORYLOGGER";
    private static final String SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER = "nl.surfnet.coin.shared.log.diagnostics.LOG_EVENTS_BUFFER";
    private MemoryAppender memoryAppender;

    public void init(FilterConfig filterConfig) throws ServletException {
        ch.qos.logback.classic.Logger memoryLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)MEMORY_LOGGER);
        this.memoryAppender = (MemoryAppender)memoryLogger.getAppender(MEMORY_APPENDER);
        if (this.memoryAppender == null || !this.memoryAppender.isStarted()) {
            throw new ServletException("Cannot start DiagnosticsLoggerFilter, memoryAppender is not started yet. (does the logback configuration contain one?)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block14: {
            String discriminator;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            StatusExposingResponse wrappedResponse = new StatusExposingResponse(res);
            HttpSession session = req.getSession(false);
            if (session == null) {
                discriminator = UUID.randomUUID().toString();
                LOG.debug("No HttpSession available, will use request-local, random discriminator: {}", (Object)discriminator);
            } else {
                discriminator = session.getId();
            }
            MDC.put((String)"nl.surfnet.coin.shared.log.diagnostics.SESSION_DISCRIMINATOR", (String)discriminator);
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
                if (wrappedResponse.getStatus() >= 400) {
                    LOG.debug("Response has error status ({}), will dump aggregated log events", (Object)wrappedResponse.getStatus());
                    this.dumpAggregatedLogEvents(discriminator, req);
                    break block14;
                }
                if (session == null) break block14;
                List<ILoggingEvent> loggingEvents = this.memoryAppender.getBuffer(discriminator);
                LOG.debug("Request processed successfully. Will save {} loggingEvents from this request in session", (Object)loggingEvents.size());
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    if (session.getAttribute(SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER) != null) {
                        ((List)session.getAttribute(SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER)).addAll(loggingEvents);
                    } else {
                        session.setAttribute(SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER, loggingEvents);
                    }
                }
            }
            catch (IOException ioe) {
                LOG.debug("Caught (checked) IOException (msg: {}), will dump aggregated log events", (Object)ioe.getMessage());
                this.dumpAggregatedLogEvents(discriminator, req);
                throw ioe;
            }
            catch (RuntimeException rte) {
                LOG.debug("Caught RTE (msg: {}), will dump aggregated log events", (Object)rte.getMessage());
                this.dumpAggregatedLogEvents(discriminator, req);
                throw rte;
            }
            finally {
                MDC.remove((String)"nl.surfnet.coin.shared.log.diagnostics.SESSION_DISCRIMINATOR");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAggregatedLogEvents(String discriminator, HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                this.memoryAppender.dumpExternal((List)session.getAttribute(SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER));
                session.removeAttribute(SESSION_ATTRIBUTE_LOG_EVENTS_BUFFER);
            }
        }
        this.memoryAppender.dump(discriminator);
    }

    public void destroy() {
    }

    public static class StatusExposingResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingResponse(HttpServletResponse response) {
            super(response);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public void reset() {
            super.reset();
            this.httpStatus = 200;
        }
    }
}

