/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.log;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import nl.surfnet.coin.shared.log.ApiCallLog;
import org.springframework.util.StringUtils;

public class ApiCallLogContextListener
implements ServletRequestListener {
    private static final ThreadLocal<ApiCallLog> apiCallLogHolder = new ThreadLocal();

    public void requestDestroyed(ServletRequestEvent sre) {
        apiCallLogHolder.set(null);
    }

    public void requestInitialized(ServletRequestEvent requestEvent) {
        ApiCallLog apiCallLog = new ApiCallLog();
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        String queryString = request.getQueryString();
        StringBuffer requestURL = request.getRequestURL();
        if (StringUtils.hasText((String)queryString)) {
            requestURL.append("?").append(queryString);
        }
        try {
            apiCallLog.setResourceUrl(URLEncoder.encode(requestURL.toString(), "utf-8"));
            apiCallLog.setIpAddress(request.getRemoteAddr());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        apiCallLogHolder.set(apiCallLog);
    }

    public static ApiCallLog getApiCallLog() {
        ApiCallLog apiCallLog = apiCallLogHolder.get();
        return apiCallLog == null ? new ApiCallLog() : apiCallLog;
    }
}

