/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shared.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.surfnet.coin.shared.domain.DomainObject;
import nl.surfnet.coin.shared.service.GenericService;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GenericServiceHibernateImpl<T extends DomainObject>
implements GenericService<T> {
    @Autowired
    private SessionFactory portalSessionFactory;
    private Class<T> persistentClass;

    public GenericServiceHibernateImpl(Class<T> type) {
        this.persistentClass = type;
    }

    @Override
    public void delete(T o) {
        this.portalSessionFactory.getCurrentSession().delete(o);
    }

    @Override
    public void detachFromSession(T o) {
        this.portalSessionFactory.getCurrentSession().evict(o);
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public List<T> findByExample(T exampleInstance) {
        return this.findByExample(exampleInstance, new String[0]);
    }

    @Override
    public List<T> findByExample(T exampleInstance, String[] excludes) {
        Example create = Example.create(exampleInstance);
        for (String name : excludes) {
            create.excludeProperty(name);
        }
        return this.findByCriteria(new Criterion[]{create});
    }

    protected List<T> findByCriteria(Criterion ... criterion) {
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>(criterion.length);
        Collections.addAll(criterionList, criterion);
        return this.findByCriteriaOrdered(criterionList, Collections.<Order>emptyList());
    }

    protected List<T> findByCriteriaOrdered(List<Criterion> criterionList, List<Order> orderList) {
        Criteria crit = this.portalSessionFactory.getCurrentSession().createCriteria(this.getPersistentClass());
        for (Criterion c : criterionList) {
            crit.add(c);
        }
        for (Order order : orderList) {
            crit.addOrder(order);
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    @Override
    public T findById(Long id) {
        return (T)((DomainObject)this.portalSessionFactory.getCurrentSession().load(this.getPersistentClass(), (Serializable)id));
    }

    @Override
    public int getCount() {
        return DataAccessUtils.intResult((Collection)this.portalSessionFactory.getCurrentSession().createQuery("select count(*) from " + this.getPersistentClass().getName()).list());
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public Long saveOrUpdate(T t) {
        this.portalSessionFactory.getCurrentSession().saveOrUpdate(t);
        return ((DomainObject)t).getId();
    }

    @Override
    public void saveOrUpdate(Collection<T> coll) {
        for (DomainObject t : coll) {
            this.saveOrUpdate(t);
        }
    }

    protected Session getSession() {
        return this.portalSessionFactory.getCurrentSession();
    }

    @Override
    public Criteria createCriteria() {
        return this.portalSessionFactory.getCurrentSession().createCriteria(this.getPersistentClass());
    }
}

