--
-- Database: `coin_shindig`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

CREATE TABLE IF NOT EXISTS `activity` (
  `id` varchar(255) NOT NULL,
  `app_id` varchar(255) default NULL,
  `body` longtext,
  `body_id` varchar(255) default NULL,
  `external_id` varchar(255) default NULL,
  `updated` datetime default NULL,
  `posted_time` bigint(20) default NULL,
  `priority` float default NULL,
  `stream_favicon_url` varchar(255) default NULL,
  `stream_source_url` varchar(255) default NULL,
  `stream_title` varchar(255) default NULL,
  `stream_url` varchar(255) default NULL,
  `title` varchar(255) default NULL,
  `title_id` varchar(255) default NULL,
  `url` varchar(255) default NULL,
  `user_id` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

CREATE TABLE IF NOT EXISTS `activity_template_params` (
  `id` varchar(255) NOT NULL,
  `value` varchar(255) default NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`,`name`),
  KEY `FK4CD57BB54AABA99` (`id`),
  CONSTRAINT `FK4CD57BB54AABA99` FOREIGN KEY (`id`) REFERENCES `activity` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `media_item`
--

CREATE TABLE IF NOT EXISTS `media_item` (
  `id` varchar(255) NOT NULL,
  `album_id` varchar(255) NOT NULL,
  `creaetd` varchar(255) NOT NULL,
  `description` varchar(255) default NULL,
  `duration` varchar(255) default NULL,
  `file_size` varchar(255) default NULL,
  `language` varchar(255) default NULL,
  `last_updated` varchar(255) default NULL,
  `media_type` tinyblob,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message`
--

CREATE TABLE IF NOT EXISTS `message` (
  `id` varchar(255) NOT NULL,
  `app_url` varchar(255) default NULL,
  `body` longtext,
  `body_id` varchar(255) default NULL,
  `in_reply_to` varchar(255) default NULL,
  `sender_id` varchar(255) default NULL,
  `message_status` varchar(255) default NULL,
  `time_sent` datetime default NULL,
  `title` varchar(255) default NULL,
  `title_id` varchar(255) default NULL,
  `message_type` varchar(255) default NULL,
  `updated` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_collection`
--

CREATE TABLE IF NOT EXISTS `message_collection` (
  `id` varchar(255) NOT NULL,
  `title` varchar(255) default NULL,
  `total` int(11) default NULL,
  `unread` int(11) default NULL,
  `updated` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_collection_ids`
--

CREATE TABLE IF NOT EXISTS `message_collection_ids` (
  `message_id` varchar(255) NOT NULL,
  `message_collection_id` varchar(255) default NULL,
  `ids_order` int(11) NOT NULL,
  PRIMARY KEY  (`message_id`,`ids_order`),
  KEY `FK9AC74CF3D79658B` (`message_id`),
  CONSTRAINT `FK9AC74CF3D79658B` FOREIGN KEY (`message_id`) REFERENCES `message` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_collection_url`
--

CREATE TABLE IF NOT EXISTS `message_collection_url` (
  `id` bigint(20) NOT NULL auto_increment,
  `link_text` varchar(255) default NULL,
  `url_type` varchar(255) default NULL,
  `url_value` varchar(255) default NULL,
  `url_primary` bit(1) default NULL,
  `message_collection_id` varchar(255) default NULL,
  `urls_order` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `FK9ACA38638A8FB1A` (`message_collection_id`),
  CONSTRAINT `FK9ACA38638A8FB1A` FOREIGN KEY (`message_collection_id`) REFERENCES `message_collection` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_recipients`
--

CREATE TABLE IF NOT EXISTS `message_recipients` (
  `message_id` varchar(255) NOT NULL,
  `recipient` varchar(255) default NULL,
  `recipients_order` int(11) NOT NULL,
  PRIMARY KEY  (`message_id`,`recipients_order`),
  KEY `FKF83BACB23D79658B` (`message_id`),
  CONSTRAINT `FKF83BACB23D79658B` FOREIGN KEY (`message_id`) REFERENCES `message` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_replies`
--

CREATE TABLE IF NOT EXISTS `message_replies` (
  `message_id` varchar(255) NOT NULL,
  `reply` varchar(255) default NULL,
  `replies_order` int(11) NOT NULL,
  PRIMARY KEY  (`message_id`,`replies_order`),
  KEY `FKF99680D03D79658B` (`message_id`),
  CONSTRAINT `FKF99680D03D79658B` FOREIGN KEY (`message_id`) REFERENCES `message` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `message_urls`
--

CREATE TABLE IF NOT EXISTS `message_urls` (
  `message_id` varchar(255) NOT NULL,
  `message_url` varchar(255) default NULL,
  `urls_order` int(11) NOT NULL,
  PRIMARY KEY  (`message_id`,`urls_order`),
  KEY `FKB3588E1C3D79658B` (`message_id`),
  CONSTRAINT `FKB3588E1C3D79658B` FOREIGN KEY (`message_id`) REFERENCES `message` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `person_app_data`
--

CREATE TABLE IF NOT EXISTS `person_app_data` (
  `id` bigint(20) NOT NULL auto_increment,
  `person_id` varchar(255) NOT NULL,
  `app_id` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `person_data_data`
--

CREATE TABLE IF NOT EXISTS `person_data_data` (
  `person_id` bigint(20) NOT NULL,
  `value` varchar(255) default NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY  (`person_id`,`name`),
  KEY `FKBEDE22B584730D2A` (`person_id`),
  CONSTRAINT `FKBEDE22B584730D2A` FOREIGN KEY (`person_id`) REFERENCES `person_app_data` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;