/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.model;

import java.util.HashMap;
import java.util.Map;

import org.apache.shindig.social.opensocial.model.Person;

/**
 * Model class containing the additional - free format - data for {@link Person}
 * . For some - unknown - reason this dataholder is not part of {@link Person}
 * in the Shindig reference implementation. We did not correct this as
 * {@link Person} is retrieved from the engineBlock anyway
 * 
 * 
 */
public class PersonAppData {
  private Long id;
  private String personId;
  private String appId;
  private Map<String, String> data = new HashMap<String, String>();

  /**
   * @return the personId
   */
  public String getPersonId() {
    return personId;
  }

  /**
   * @param personId
   *          the personId to set
   */
  public void setPersonId(String personId) {
    this.personId = personId;
  }

  /**
   * @return the data
   */
  public Map<String, String> getData() {
    return data;
  }

  /**
   * @param data
   *          the data to set
   */
  public void setData(Map<String, String> data) {
    this.data = data;
  }

  /**
   * @return the appId
   */
  public String getAppId() {
    return appId;
  }

  /**
   * @param appId
   *          the appId to set
   */
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * @return the id
   */
  public Long getId() {
    return id;
  }

  /**
   * @param id
   *          the id to set
   */
  public void setId(Long id) {
    this.id = id;
  }

}
