/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 
 */
package nl.surfnet.coin.shindig.spi;

import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author steinwelberg
 *
 */
@Component(value = "oAuthEntryService")
@Transactional
public class OAuthEntryServiceImpl implements OAuthEntryService {
  
  @Autowired
  private SessionFactory sessionFactory;

  /*
   * Hibernate class
   */
  private static final String OAUTH_ENTRY = OAuthEntry.class.getName();


  /* (non-Javadoc)
   * @see nl.surfnet.coin.shindig.spi.OAuthEntryService#getOAuthEntry(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
   */
  @SuppressWarnings("unchecked")
  @Override
  public OAuthEntry getOAuthEntry(String oauthToken) {
    Criteria crit = sessionFactory.getCurrentSession().createCriteria(
        OAUTH_ENTRY);
    crit.add(Restrictions.eq("token", oauthToken));
    crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
    return (OAuthEntry) DataAccessUtils.singleResult(crit.list());
  }

  /* (non-Javadoc)
   * @see nl.surfnet.coin.shindig.spi.OAuthEntryService#saveOAuthEntry(org.apache.shindig.social.opensocial.oauth.OAuthEntry)
   */
  @Override
  public void saveOAuthEntry(OAuthEntry oauthEntry) {
    sessionFactory.getCurrentSession().saveOrUpdate(OAUTH_ENTRY, oauthEntry);
  }

  @Override
  public void deleteOAuthEntry(String oauthToken) {
    OAuthEntry oauthEntry = getOAuthEntry(oauthToken);
    if (oauthEntry != null) {
      sessionFactory.getCurrentSession().delete(OAUTH_ENTRY, oauthEntry);
    }
  }
}
