/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;

/**
 * Service for storing and retrieving {@link CoinOAuthTokenInfo} instances
 * 
 */
public interface TokenInfoService {

  CoinOAuthTokenInfo getCoinOAuthTokenInfo(String userId,
      String gadgetUri, String moduleId, String tokenName, String serviceName);

  void saveCoinOAuthTokenInfo(CoinOAuthTokenInfo tokenInfo);
  
  void deleteCoinOAuthTokenInfo(String userId,
      String gadgetUri, String moduleId, String tokenName, String serviceName);

}
