/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;

/**
 * Implementation of {@link TokenInfoService} based on hibernate
 * 
 */
@Component(value = "tokenInfoService")
@Transactional
public class TokenInfoServiceImpl implements TokenInfoService {

  @Autowired
  private SessionFactory sessionFactory;

  /*
   * Hibernate class
   */
  private static final String TOKEN_INFO = CoinOAuthTokenInfo.class.getName();

  /**
   * @param sessionFactory
   *          the sessionFactory to set
   */
  public void setSessionFactory(SessionFactory sessionFactory) {
    this.sessionFactory = sessionFactory;
  }

  @SuppressWarnings("unchecked")
  @Override
  public CoinOAuthTokenInfo getCoinOAuthTokenInfo(String userId,
      String gadgetUri, String moduleId, String tokenName, String serviceName) {
    Criteria crit = sessionFactory.getCurrentSession().createCriteria(
        TOKEN_INFO);
    crit.add(Restrictions.eq("userId", userId))
        .add(Restrictions.eq("appUrl", gadgetUri))
        .add(Restrictions.eq("moduleId", moduleId))
        .add(Restrictions.eq("tokenName", tokenName))
        .add(Restrictions.eq("serviceName", serviceName));
    crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
    return (CoinOAuthTokenInfo ) DataAccessUtils.singleResult(crit.list());
  }

  @Override
  public void saveCoinOAuthTokenInfo(CoinOAuthTokenInfo tokenInfo) {
    sessionFactory.getCurrentSession().saveOrUpdate(TOKEN_INFO, tokenInfo);
  }

  @Override
  public void deleteCoinOAuthTokenInfo(String userId, String gadgetUri,
      String moduleId, String tokenName, String serviceName) {
    CoinOAuthTokenInfo tokenInfo = getCoinOAuthTokenInfo(userId, gadgetUri, moduleId, tokenName, serviceName);
    if (tokenInfo != null) {
      sessionFactory.getCurrentSession().delete(TOKEN_INFO, tokenInfo);
    }
  }
}
