/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.oauth;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shared.service.impl.MockMailService;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

/**
 * Test for {@link CoinOAuthDataStore}
 */
public class CoinOAuthDataStoreTest extends AbstractMockHttpServerTest {

  private CoinOAuthDataStore dataStore;

  @Before
  public void setup() {
    ErrorMessageMailer errorMessageMailer = new ErrorMessageMailer();
    dataStore = new CoinOAuthDataStore();
    dataStore.setErrorMessageMailer(errorMessageMailer);
    ContextEnvironment environment = new ContextEnvironment();
    environment.setBaseSocialApiUrl("http://localhost:8088");
    dataStore.setEnvironment(environment);
    dataStore.setHttpClientProvider(new HttpClientProvider());
  }

  @Test
  public void testGetConsumer() throws Exception {
    setResponseResource(new ClassPathResource("json/mock-oauth-secret.json"));
    OAuthConsumer consumer = dataStore.getConsumer("testkey");

    assertEquals("testsecret", consumer.consumerSecret);
  }

  @Test
  public void testGetEmptyConsumer() throws Exception {
    setResponseResource(new ClassPathResource(
            "json/mock-oauth-empty-secret.json"));
    try {
      dataStore.getConsumer("testkey");
      fail("Expected oauthException");
    } catch (OAuthException e) {
      // ok
    }

  }
}
