/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.shindig.oauth;

import static org.junit.Assert.*;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

/**
 * 
 *
 */
public class CoinVoFilterTest {

  /**
   * Test method for {@link nl.surfnet.coin.shindig.oauth.CoinVoFilter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)}.
   * @throws ServletException  unexpected
   * @throws IOException unexpected
   */
  @Test
  public void testDoFilter() throws IOException, ServletException {
    CoinVoFilter filter = new CoinVoFilter();
    MockHttpServletRequest request = new MockHttpServletRequest("GET", "/vo/someVo/social/rest");
    request.setQueryString("key=value");
    MockHttpServletResponse response = new MockHttpServletResponse();
    MockFilterChain chain = new MockFilterChain();
    filter.doFilter(request , response , chain );
    
    String forwardedUrl = response.getForwardedUrl();
    assertEquals("/social/rest?key=value&vo=someVo", forwardedUrl);
  }

}
