/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import static org.junit.Assert.assertEquals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

/**
 * {@link Test} for {@link AppDataServiceImpl}
 * 
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
    "classpath:coin-shindig-hsqldb-properties-context.xml",
    "classpath:coin-shindig-context.xml",
    "classpath:coin-shared-context.xml" })
@TransactionConfiguration(transactionManager = "transactionManager", defaultRollback = true)
@Transactional
public class AppDataServiceImplTest {

  @Autowired
  private AppDataService appDataService;

  @Autowired
  private SessionFactory sessionFactory;

  private String appId1 = "app1";
  private String appId2 = "app2";

  private String personId1 = "personId1";
  private String personId2 = "personId2";

  @Before
  public void setupDbContent() {
    createPersonAppData(appId1, personId1, "key1", "value1");
    createPersonAppData(appId1, personId2, "key2", "value2");
    createPersonAppData(appId2, personId2, "key3", "value3");
  }

  /*
   * Create a PersonAppData
   */
  private void createPersonAppData(String appId, String personId, String key,
      String value) {
    Map<String, String> data = new HashMap<String, String>();
    data.put(key, value);
    appDataService.updatePersonData(new UserId(UserId.Type.userId, personId),
        null, appId, null, data, null);
    sessionFactory.getCurrentSession().flush();
  }

  @After
  public void flushSession() {
    // flushing forces the actual sql to be executed
    sessionFactory.getCurrentSession().flush();
  }

  @Test
  public void testGetAppData() throws ProtocolException, InterruptedException,
      ExecutionException {
    // person1 has 1 AppData
    DataCollection dataCollection = appDataService.getPersonData(
        Collections.singleton(new UserId(UserId.Type.userId, personId1)), null,
        appId1, null, null).get();
    Map<String, Map<String, String>> entry = dataCollection.getEntry();
    assertEquals(1, entry.size());
    String value = entry.get(appId1).get("key1");
    assertEquals(value, "value1");

    // person2 has 2 AppData
    dataCollection = appDataService.getPersonData(
        Collections.singleton(new UserId(UserId.Type.userId, personId2)), null,
        null, null, null).get();
    entry = dataCollection.getEntry();
    assertEquals(2, entry.size());
  }
}
