/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.apache.shindig.common.crypto.BlobCrypterException;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;

/**
 * {@link Test} for {@link TokenInfoServiceImpl}
 * 
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {
    "classpath:coin-shindig-hsqldb-properties-context.xml",
    "classpath:coin-shindig-context.xml",
    "classpath:coin-shared-context.xml" })
@TransactionConfiguration(transactionManager = "transactionManager", defaultRollback = true)
@Transactional
public class TokenInfoServiceImplTest extends AbstractMockHttpServerTest {

  @Autowired
  private TokenInfoService tokenInfoService;

  @Autowired
  private SessionFactory sessionFactory;

  @Before
  public void setupDbContent() throws Exception {
    CoinOAuthTokenInfo info = new CoinOAuthTokenInfo();
    info.setAccessToken("accessToken");
    info.setAppUrl("appUrl");
    info.setModuleId("moduleId");
    info.setServiceName("serviceName");
    info.setSessionHandle("sessionHandle");
    info.setTokenName("tokenName");
    info.setTokenSecret("tokenSecret");
    info.setUserId("userId");

    tokenInfoService.saveCoinOAuthTokenInfo(info);

    flushSession();

  }

  @After
  public void flushSession() {
    // flushing forces the actual sql to be executed
    sessionFactory.getCurrentSession().flush();
  }

  @Test
  public void testCoinOAuthTokenInfo() {
    CoinOAuthTokenInfo info = tokenInfoService.getCoinOAuthTokenInfo("userId",
        "appUrl", "moduleId", "tokenName", "serviceName");
    assertNotNull(info.getId());
  }
  
  @Test
  public void testDeleteCoinOAuthTokenInfo() throws BlobCrypterException {
    tokenInfoService.deleteCoinOAuthTokenInfo("userId",
        "appUrl", "moduleId", "tokenName", "serviceName");
    flushSession();
    
    CoinOAuthTokenInfo info = tokenInfoService.getCoinOAuthTokenInfo("userId",
        "appUrl", "moduleId", "tokenName", "serviceName");
    
    assertNull(info);
  }

}
