/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.List;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shared.log.ApiCallLogService;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import nl.surfnet.coin.shindig.spi.ApiCallLogServiceMock;
import nl.surfnet.coin.shindig.spi.GroupServiceImpl;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GroupServiceImplTest
extends AbstractMockHttpServerTest {
    private GroupServiceImpl groupService = new GroupServiceImpl();

    public GroupServiceImplTest() {
        ContextEnvironment environment = new ContextEnvironment();
        environment.setBaseSocialApiUrl("http://localhost:8088/social/groups");
        this.groupService.setEnvironment(environment);
        this.groupService.setHttpClientProvider(new HttpClientProvider());
        this.groupService.setErrorMessageMailer(new ErrorMessageMailer());
        this.groupService.setLogService((ApiCallLogService)new ApiCallLogServiceMock());
    }

    @Test
    public void testGetPersonGroups() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "urn:collab:person:surfnet.nl:hansz");
        SecurityToken token = (SecurityToken)Mockito.mock(SecurityToken.class);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-multiple-teams.json"));
        List groups = ((RestfulCollection)this.groupService.getGroups(id, null, null, token).get()).getEntry();
        Assert.assertEquals((long)4L, (long)groups.size());
        for (Group group : groups) {
            Assert.assertNotNull((Object)group.getTitle());
        }
        this.setResponseResource((Resource)new ClassPathResource("json/mock-single-team.json"));
        groups = ((RestfulCollection)this.groupService.getGroups(id, null, null, token).get()).getEntry();
        Assert.assertEquals((long)1L, (long)groups.size());
        this.setResponseResource((Resource)new ClassPathResource("json/mock-empty-team.json"));
        groups = ((RestfulCollection)this.groupService.getGroups(id, null, null, token).get()).getEntry();
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testGetPersonGroupsSecurityException() throws Exception {
        UserId id = new UserId(UserId.Type.userId, "personId");
        OAuthSecurityToken token = new OAuthSecurityToken("onBehalfOf", "appUrl", "appId", "domain", "container", Long.valueOf(Long.MAX_VALUE), "authMode", null, null);
        this.setResponseResource((Resource)new ClassPathResource("json/mock-multiple-teams.json"));
        try {
            ((RestfulCollection)this.groupService.getGroups(id, null, null, (SecurityToken)token).get()).getEntry();
            Assert.fail((String)"IllegalArgumentException because of security breach ");
        }
        catch (RuntimeException e) {
            String message = e.getCause().getMessage();
            Assert.assertTrue((boolean)message.contains("not granted"));
        }
    }
}

