/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Date;
import java.util.UUID;
import nl.surfnet.coin.mock.AbstractMockHttpServerTest;
import nl.surfnet.coin.shindig.spi.OAuthEntryService;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:coin-shindig-hsqldb-properties-context.xml", "classpath:coin-shindig-context.xml", "classpath:coin-shared-context.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class OAuthEntryServiceImplTest
extends AbstractMockHttpServerTest {
    @Autowired
    private OAuthEntryService oAuthEntryService;
    @Autowired
    private SessionFactory sessionFactory;
    private static final String TOKEN = UUID.randomUUID().toString();

    @Before
    public void setupDbContent() throws Exception {
        OAuthEntry entry = new OAuthEntry();
        entry.setAppId("appId");
        entry.setAuthorized(false);
        entry.setCallbackToken("callbackToken");
        entry.setCallbackTokenAttempts(0);
        entry.setCallbackUrl("callbackUrl");
        entry.setConsumerKey("consumerKey");
        entry.setContainer("container");
        entry.setDomain("domain");
        entry.setIssueTime(new Date());
        entry.setOauthVersion("1.0");
        entry.setToken(TOKEN);
        entry.setType(OAuthEntry.Type.REQUEST);
        this.oAuthEntryService.saveOAuthEntry(entry);
        this.flushSession();
    }

    @After
    public void flushSession() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testOAuthEntry() {
        OAuthEntry entry = this.oAuthEntryService.getOAuthEntry(TOKEN);
        Assert.assertEquals((Object)TOKEN, (Object)entry.getToken());
    }

    @Test
    public void testDeleteOAuthEntry() throws BlobCrypterException {
        this.oAuthEntryService.deleteOAuthEntry(TOKEN);
        this.flushSession();
        OAuthEntry entry = this.oAuthEntryService.getOAuthEntry(TOKEN);
        Assert.assertNull((Object)entry);
    }
}

