/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import nl.surfnet.coin.shared.domain.ErrorMail;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.spi.AbstractRestDelegationService;
import nl.surfnet.coin.shindig.spi.OAuthEntryService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="oAuthDataStore")
public class CoinOAuthDataStore
extends AbstractRestDelegationService
implements OAuthDataStore {
    private static final int CALLBACK_TOKEN_LENGTH = 6;
    private static final int CALLBACK_TOKEN_ATTEMPTS = 5;
    private static final ImmutableList<String> ADDITIONAL_PROPERTIES = ImmutableList.of((Object)"coin:oauth:app_title", (Object)"coin:oauth:app_description", (Object)"coin:oauth:app_thumbnail", (Object)"coin:oauth:app_icon", (Object)"entityId");
    private final OAuthServiceProvider SERVICE_PROVIDER;
    private static final String DOMAIN = "surfnet.nl";
    @Autowired
    private OAuthEntryService oAuthEntryService;
    @Autowired
    private ErrorMessageMailer errorMessageMailer;
    private Logger logger = Logger.getLogger(this.getClass());

    public CoinOAuthDataStore() {
        String baseUrl = "/oauth/";
        this.SERVICE_PROVIDER = new OAuthServiceProvider(baseUrl + "requestToken", baseUrl + "authorize", baseUrl + "accessToken");
    }

    public OAuthEntry getEntry(String oauthToken) {
        return this.doGetEntry(oauthToken);
    }

    private OAuthEntry doGetEntry(String oauthToken) {
        return this.oAuthEntryService.getOAuthEntry(oauthToken);
    }

    public SecurityToken getSecurityTokenForConsumerRequest(String consumerKey, String userId, OAuthConsumer authConsumer) throws OAuthProblemException {
        String container = this.getEnvironment().getContainerName();
        return new OAuthSecurityToken(userId, null, consumerKey, DOMAIN, container, null, AuthenticationMode.OAUTH_CONSUMER_REQUEST.name(), null, (String)authConsumer.getProperty("entityId"));
    }

    public OAuthConsumer getConsumer(String consumerKey) throws OAuthProblemException {
        return this.doGetConsumer(consumerKey);
    }

    private OAuthConsumer doGetConsumer(String consumerKey) throws OAuthProblemException {
        HashMap result;
        String url = this.getEnvironment().getBaseSocialApiUrl();
        String json = null;
        try {
            url = url + "/service/metadata?gadgeturl=" + URLEncoder.encode(consumerKey, "UTF-8") + "&keys=" + URLEncoder.encode("coin:oauth:secret,coin:oauth:public_key,coin:oauth:app_title,coin:oauth:app_description,coin:oauth:app_thumbnail,coin:oauth:app_icon,coin:oauth:callback_url,entityId", "UTF-8");
            json = IOUtils.toString((InputStream)this.executeHttpGet(url));
            result = (HashMap)this.getObjectMapper().readValue(json, HashMap.class);
        }
        catch (Exception e) {
            String shortMessage = "Unexpected exception occured in retrieving Consumer";
            String formattedMessage = String.format("Unexpected exception occured in retrieving Consumer while parsing (%s) for gadgetUrl " + consumerKey, json);
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + formattedMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, e.getMessage(), this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#doGetConsumer");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new OAuthProblemException(shortMessage + " " + e.getMessage());
        }
        String consumerSecret = (String)result.get("coin:oauth:secret");
        String callbackUrl = (String)result.get("coin:oauth:callback_url");
        boolean isPublicKey = result.containsKey("coin:oauth:public_key");
        if (!StringUtils.hasText((String)consumerSecret) && !isPublicKey) {
            String shortMessage = "No secret nor public key for consumerKey  " + consumerKey;
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, "UNKNOWN", this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#doGetConsumer");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new OAuthProblemException(shortMessage);
        }
        OAuthConsumer consumer = !isPublicKey ? new OAuthConsumer(callbackUrl, consumerKey, consumerSecret, this.SERVICE_PROVIDER) : new OAuthConsumer(callbackUrl, consumerKey, null, this.SERVICE_PROVIDER);
        if (isPublicKey) {
            this.setCertificate(consumer, (String)result.get("coin:oauth:public_key"));
        }
        this.setAdditionalProperties(consumer, result);
        return consumer;
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    private void setAdditionalProperties(OAuthConsumer consumer, HashMap<String, Object> map) {
        for (String key : ADDITIONAL_PROPERTIES) {
            if (!map.containsKey(key)) continue;
            consumer.setProperty(key, (Object)((String)map.get(key)));
        }
    }

    private void setCertificate(OAuthConsumer consumer, String publicKey) throws OAuthProblemException {
        byte[] buffer = Base64.decodeBase64((String)publicKey);
        try {
            CertificateFactory fac = CertificateFactory.getInstance("X509");
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
            consumer.setProperty("RSA-SHA1.X509Certificate", (Object)cert);
        }
        catch (CertificateException e) {
            throw new OAuthProblemException("Could not create certificate from public key.");
        }
    }

    public OAuthEntry generateRequestToken(String consumerKey, String oauthVersion, String signedCallbackUrl, String virtualOrganization) throws OAuthProblemException {
        return this.doGenerateRequestToken(consumerKey, oauthVersion, signedCallbackUrl, virtualOrganization);
    }

    private OAuthEntry doGenerateRequestToken(String consumerKey, String oauthVersion, String signedCallbackUrl, String virtualOrganization) {
        OAuthEntry entry = new OAuthEntry();
        entry.setAppId(consumerKey);
        entry.setConsumerKey(consumerKey);
        entry.setDomain(DOMAIN);
        entry.setContainer(this.getEnvironment().getContainerName());
        entry.setVirtualOrganization(virtualOrganization);
        entry.setToken(UUID.randomUUID().toString());
        entry.setTokenSecret(UUID.randomUUID().toString());
        entry.setType(OAuthEntry.Type.REQUEST);
        entry.setIssueTime(new Date());
        entry.setOauthVersion(oauthVersion);
        if (signedCallbackUrl != null) {
            entry.setCallbackUrlSigned(true);
            entry.setCallbackUrl(signedCallbackUrl);
        }
        this.oAuthEntryService.saveOAuthEntry(entry);
        return entry;
    }

    public OAuthEntry convertToAccessToken(OAuthEntry entry) throws OAuthProblemException {
        Preconditions.checkNotNull((Object)entry);
        Preconditions.checkState((entry.getType() == OAuthEntry.Type.REQUEST ? 1 : 0) != 0, (Object)"Token must be a request token");
        OAuthEntry accessEntry = new OAuthEntry(entry);
        accessEntry.setToken(UUID.randomUUID().toString());
        accessEntry.setTokenSecret(UUID.randomUUID().toString());
        accessEntry.setType(OAuthEntry.Type.ACCESS);
        accessEntry.setIssueTime(new Date());
        this.oAuthEntryService.deleteOAuthEntry(entry.getToken());
        this.oAuthEntryService.saveOAuthEntry(accessEntry);
        return accessEntry;
    }

    public void authorizeToken(OAuthEntry entry, String userId) throws OAuthProblemException {
        Preconditions.checkNotNull((Object)entry);
        entry.setAuthorized(true);
        entry.setUserId((String)Preconditions.checkNotNull((Object)userId));
        if (entry.isCallbackUrlSigned()) {
            entry.setCallbackToken(Crypto.getRandomDigits((int)6));
        }
        this.oAuthEntryService.saveOAuthEntry(entry);
    }

    public void disableToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        entry.setCallbackTokenAttempts(entry.getCallbackTokenAttempts() + 1);
        if (!entry.isCallbackUrlSigned() || entry.getCallbackTokenAttempts() >= 5) {
            entry.setType(OAuthEntry.Type.DISABLED);
        }
        this.oAuthEntryService.saveOAuthEntry(entry);
    }

    public void removeToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        this.oAuthEntryService.deleteOAuthEntry(entry.getToken());
    }

    public void setErrorMessageMailer(ErrorMessageMailer errorMessageMailer) {
        this.errorMessageMailer = errorMessageMailer;
    }
}

