/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import nl.surfnet.coin.shared.domain.ErrorMail;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.oauth.CoinOAuthTokenInfo;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import nl.surfnet.coin.shindig.spi.TokenInfoService;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class CoinOAuthStore
implements OAuthStore {
    private String defaultCallbackUrl;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private HttpClientProvider httpClientProvider = new HttpClientProvider();
    private TokenInfoService tokenInfoService;
    private String baseUrl;
    private BasicOAuthStoreConsumerKeyAndSecret defaultKey;
    private ErrorMessageMailer errorMessageMailer;

    public CoinOAuthStore(String defaultCallbackUrl, String baseUrl, TokenInfoService tokenInfoService, String pathToPrivateKey, String privateKeyName, ErrorMessageMailer errorMessageMailer) throws IOException {
        this.baseUrl = baseUrl;
        this.defaultCallbackUrl = defaultCallbackUrl;
        this.tokenInfoService = tokenInfoService;
        this.defaultKey = this.loadDefaultKey(pathToPrivateKey, privateKeyName);
        this.errorMessageMailer = errorMessageMailer;
    }

    private BasicOAuthStoreConsumerKeyAndSecret loadDefaultKey(String signingKeyFile, String signingKeyName) throws IOException {
        InputStream inputStream = new ClassPathResource(signingKeyFile).getInputStream();
        String privateKey = IOUtils.toString((InputStream)inputStream);
        privateKey = BasicOAuthStore.convertFromOpenSsl((String)privateKey);
        return new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
    }

    public OAuthStore.ConsumerInfo getConsumerKeyAndSecret(SecurityToken securityToken, String serviceName, OAuthServiceProvider provider) throws GadgetException {
        try {
            String gadgetUrl = securityToken.getAppUrl();
            return this.doGetConsumerKeyAndSecret(gadgetUrl, serviceName, provider, securityToken);
        }
        catch (Exception e) {
            String shortMessage = "Exception in getConsumerKeyAndSecret";
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, e.getMessage(), this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#getConsumerKeyAndSecret");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, shortMessage, (Throwable)e);
        }
    }

    private OAuthStore.ConsumerInfo doGetConsumerKeyAndSecret(String gadgetUrl, String serviceName, OAuthServiceProvider provider, SecurityToken securityToken) throws IOException, GadgetException {
        OAuthConsumer consumer;
        HashMap results;
        String json = this.getOAuthJsonString(gadgetUrl);
        try {
            results = (HashMap)objectMapper.readValue(json, HashMap.class);
        }
        catch (Throwable t) {
            String shortMessage = "Unexpected exception while parsing json from EB";
            String formattedMessage = "Unexpected exception while parsing json('" + json + "') from EB ";
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + formattedMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, t.getMessage(), this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#doGetConsumerKeyAndSecret");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, errorMessage);
        }
        String consumerKey = (String)results.get("coin:oauth:consumer_key");
        String consumerSecret = (String)results.get("coin:oauth:consumer_secret");
        String keyType = (String)results.get("coin:oauth:key_type");
        String entityId = (String)results.get("entityId");
        if (!(StringUtils.hasText((String)consumerKey) && StringUtils.hasText((String)consumerSecret) && StringUtils.hasText((String)keyType) && StringUtils.hasText((String)entityId))) {
            String shortMessage = "no Key for gadget (" + gadgetUrl + ")";
            String formattedMessage = "No key for for gadget " + gadgetUrl + " and service " + serviceName + " and entityId " + entityId;
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + formattedMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, "UNKNOWN", this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#doGetConsumerKeyAndSecret");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, errorMessage);
        }
        if ("RSA_PRIVATE".equals(keyType)) {
            consumer = new OAuthConsumer(null, consumerKey, null, provider);
            consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)this.defaultKey.getConsumerSecret());
        } else if ("HMAC_SHA1".equals(keyType)) {
            consumer = new OAuthConsumer(null, consumerKey, consumerSecret, provider);
            consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        } else if ("PLAINTEXT".equals(keyType)) {
            consumer = new OAuthConsumer(null, consumerKey, consumerSecret, provider);
            consumer.setProperty("oauth_signature_method", (Object)"PLAINTEXT");
        } else {
            String errorMessage = "Could not determine a suitable signature method (" + keyType + "). Only 'HMAC_SHA1', 'RSA_PRIVATE' or 'PLAINTEXT' are currently supported!";
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, errorMessage);
        }
        consumer.setProperty("entityId", (Object)entityId);
        return new OAuthStore.ConsumerInfo(consumer, null, this.defaultCallbackUrl);
    }

    public OAuthStore.TokenInfo getTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        OAuthStore.TokenInfo tokenInfo = null;
        CoinOAuthTokenInfo info = this.tokenInfoService.getCoinOAuthTokenInfo(securityToken.getViewerId(), securityToken.getAppUrl(), "NOT_USED", tokenName, serviceName);
        if (info != null) {
            tokenInfo = new OAuthStore.TokenInfo(info.getAccessToken(), info.getTokenSecret(), info.getSessionHandle(), info.getTokenExpireMillis());
        }
        return tokenInfo;
    }

    public void setTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName, OAuthStore.TokenInfo tokenInfo) {
        CoinOAuthTokenInfo info = new CoinOAuthTokenInfo(securityToken, serviceName, tokenName, tokenInfo);
        this.tokenInfoService.saveCoinOAuthTokenInfo(info);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) throws GadgetException {
        this.tokenInfoService.deleteCoinOAuthTokenInfo(securityToken.getViewerId(), securityToken.getAppUrl(), "NOT_USED", tokenName, serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOAuthJsonString(String gadgetUrl) throws IOException, GadgetException {
        String json;
        String url = this.baseUrl + "/service/metadata?gadgeturl=" + URLEncoder.encode(gadgetUrl, "UTF-8") + "&keys=" + URLEncoder.encode("coin:oauth:consumer_key,coin:oauth:consumer_secret,coin:oauth:key_type,entityId", "UTF-8");
        InputStream inputStream = this.httpClientProvider.getHttpClient().execute((HttpUriRequest)new HttpGet(url)).getEntity().getContent();
        try {
            json = IOUtils.toString((InputStream)inputStream);
        }
        finally {
            inputStream.close();
        }
        if (!StringUtils.hasText((String)json)) {
            String shortMessage = String.format("Url '%s' returned empty result", url);
            String errorMessage = "An exception occured during the oAuth handling in the Shindig server.<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, "UNKNOWN", this.getHost(), "Shindig");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new GadgetException(GadgetException.Code.EMPTY_XML_DOCUMENT, shortMessage);
        }
        return json;
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }
}

