/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.oauth.CoinOAuthStore;
import nl.surfnet.coin.shindig.spi.CoinGuiceModule;
import nl.surfnet.coin.shindig.spi.TokenInfoService;
import org.apache.shindig.gadgets.oauth.OAuthStore;

@Singleton
public class CoinOAuthStoreProvider
implements Provider<OAuthStore> {
    private static final String OAUTH_CALLBACK_URL = "shindig.signing.global-callback-url";
    private static final String ENGINE_BLOCK_BASE_URL = "base-social-api-url";
    private static final String OAUTH_SIGNING_KEY_FILE = "shindig.signing.key-file";
    private static final String OAUTH_SIGNING_KEY_NAME = "shindig.signing.key-name";
    private final CoinOAuthStore store;

    @Inject
    public CoinOAuthStoreProvider(@Named(value="shindig.signing.global-callback-url") String defaultCallbackUrl, @Named(value="base-social-api-url") String baseUrl, @Named(value="shindig.signing.key-file") String pathToPrivateKey, @Named(value="shindig.signing.key-name") String privateKeyName) throws IOException {
        this.store = new CoinOAuthStore(defaultCallbackUrl, baseUrl, this.getTokenInfoService(), pathToPrivateKey, privateKeyName, this.getErrorMessageMailer());
    }

    protected ErrorMessageMailer getErrorMessageMailer() {
        return (ErrorMessageMailer)CoinGuiceModule.getContext().getBean("errorMessageMailer", ErrorMessageMailer.class);
    }

    protected TokenInfoService getTokenInfoService() {
        return (TokenInfoService)CoinGuiceModule.getContext().getBean("tokenInfoService", TokenInfoService.class);
    }

    public OAuthStore get() {
        return this.store;
    }
}

