/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.oauth;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.servlet.InjectedFilter;

public class CoinVoFilter
extends InjectedFilter {
    private static final ThreadLocal<String> VIRTUAL_ORGANIZATION_CONTEXT = new ThreadLocal();
    private static final String VO_PREFIX = "/vo/";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.doForward(request, response);
        }
        catch (Exception e) {
            chain.doFilter(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String requestURI = req.getRequestURI();
        String vo = requestURI.substring(VO_PREFIX.length(), requestURI.indexOf("/", VO_PREFIX.length()));
        vo = URLEncoder.encode(vo, "UTF-8");
        VIRTUAL_ORGANIZATION_CONTEXT.set(vo);
        String queryString = req.getQueryString();
        queryString = StringUtils.isBlank((String)queryString) ? "" : queryString + "&";
        String newPath = requestURI.substring(VO_PREFIX.length() + vo.length()) + "?" + queryString + "vo=" + vo;
        RequestDispatcher requestDispatcher = req.getRequestDispatcher(newPath);
        requestDispatcher.forward(request, response);
    }

    public void destroy() {
    }

    public static String getVirtualOrganizationContext() {
        String result = VIRTUAL_ORGANIZATION_CONTEXT.get();
        VIRTUAL_ORGANIZATION_CONTEXT.set(null);
        return result;
    }
}

