/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.spi.CoinGuiceModule;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.util.StringUtils;

public class StatusPageServlet
extends HttpServlet {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(StatusPageServlet.class);
    private static final String USAGE = "<html><head><title>Shindig status page - usage</title></head><body><h1>Usage:</h1><p>To check the status you have to add one (or all) of the following url parameters:</p><table><thead><tr><th>Parameter</th><th>Example</th><th>Description</th></tr></thead><tbody><tr><td>person</td><td>urn:collab:person:surfguest.nl:steinwelberg</td><td>The UserID for the person to retrieve.</td></tr><tr><td>group</td><td>urn:collab:person:test.surfguest.nl:steinwelberg</td><td>The UserID for the person to retrieve the groups for.</td></tr><tr><td>oauth</td><td>http://gadgets.steinwelberg.nl/christiaanoauth.xml</td><td>The gagdet base url for the gadget to test oauth for.</td></tr></tbody></table><h1>Example:</h1><p>%s?person=john.doe&group=john.doe&oauth=http://gadgets.steinwelberg.nl/christiaanoauth.xml</p></body></html>";
    private HttpClient httpClient = new DefaultHttpClient();
    private boolean error;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String person = req.getParameter("person");
        String group = req.getParameter("group");
        String gadgetBaseUrl = req.getParameter("oauth");
        this.error = false;
        String output = "";
        if (gadgetBaseUrl != null && StringUtils.hasText((String)gadgetBaseUrl)) {
            output = output + this.checkOauth(gadgetBaseUrl);
        }
        if (person != null && StringUtils.hasText((String)person)) {
            if (StringUtils.hasText((String)output)) {
                output = output + ", ";
            }
            output = output + this.checkPerson(person);
        }
        if (group != null && StringUtils.hasText((String)group)) {
            if (StringUtils.hasText((String)output)) {
                output = output + ", ";
            }
            output = output + this.checkGroup(group);
        }
        if (!StringUtils.hasText((String)output)) {
            this.error = true;
            output = output + String.format(USAGE, req.getRequestURL());
        }
        if (this.error) {
            resp.setStatus(500);
        } else {
            resp.setStatus(200);
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        try {
            resp.getOutputStream().write(output.getBytes());
        }
        catch (IOException e) {
            throw new ServletException("Could not write response body", (Throwable)e);
        }
    }

    private String checkOauth(String gadgetBaseUrl) {
        String consumerSecret;
        String url = this.getEnvironment().getBaseSocialApiUrl();
        String json = null;
        try {
            url = url + "/service/metadata?gadgeturl=" + URLEncoder.encode(gadgetBaseUrl, "UTF-8") + "&keys=" + URLEncoder.encode("coin:oauth:secret", "UTF-8");
            json = IOUtils.toString((InputStream)this.executeHttpGet(url));
            HashMap result = (HashMap)objectMapper.readValue(json, HashMap.class);
            consumerSecret = (String)result.get("coin:oauth:secret");
        }
        catch (Exception e) {
            String errorMessage = String.format("Unexpected exception occured in retrieving Consumer while parsing (%s)", json);
            logger.error((Object)errorMessage, (Throwable)e);
            return "oAuth Failed";
        }
        if (!StringUtils.hasText((String)consumerSecret)) {
            this.error = true;
        }
        return StringUtils.hasText((String)consumerSecret) ? "oAuth OK" : "oAuth Failed";
    }

    private String checkPerson(String personId) throws ServletException {
        logger.debug((Object)("Checking for Person: " + personId));
        Person person = null;
        Future personFuture = this.getPersonService().getPerson(new UserId(UserId.Type.userId, personId), null, null);
        if (personFuture != null) {
            try {
                person = (Person)personFuture.get();
            }
            catch (InterruptedException e) {
                throw new ServletException("Could not fetch person", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ServletException("Could not fetch person", (Throwable)e);
            }
        }
        if (person == null || !person.getId().equals(personId)) {
            this.error = true;
        }
        return person != null && person.getId().equals(personId) ? "Person OK" : "Person Failed";
    }

    private String checkGroup(String personId) throws ServletException {
        logger.debug((Object)("checking groups for person: " + personId));
        int groups = 0;
        Future groupsFuture = this.getGroupService().getGroups(new UserId(UserId.Type.userId, personId), null, null, null);
        if (groupsFuture != null) {
            try {
                groups = ((RestfulCollection)groupsFuture.get()).getTotalResults();
            }
            catch (InterruptedException e) {
                throw new ServletException("Could not fetch person", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ServletException("Could not fetch person", (Throwable)e);
            }
        }
        if (groups == 0) {
            this.error = true;
        }
        return groups > 0 ? "Group OK" : "Group Failed";
    }

    protected PersonService getPersonService() {
        return (PersonService)CoinGuiceModule.getContext().getBean("personService", PersonService.class);
    }

    protected GroupService getGroupService() {
        return (GroupService)CoinGuiceModule.getContext().getBean("groupService", GroupService.class);
    }

    protected ContextEnvironment getEnvironment() {
        return (ContextEnvironment)CoinGuiceModule.getContext().getBean("environment", ContextEnvironment.class);
    }

    protected InputStream executeHttpGet(String url) throws ClientProtocolException, IOException {
        return this.httpClient.execute((HttpUriRequest)new HttpGet(url)).getEntity().getContent();
    }
}

