/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.io.IOException;
import java.io.InputStream;
import nl.surfnet.coin.shared.log.ApiCallLog;
import nl.surfnet.coin.shared.log.ApiCallLogContextListener;
import nl.surfnet.coin.shared.log.ApiCallLogService;
import nl.surfnet.coin.shindig.oauth.CoinVoFilter;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import nl.surfnet.coin.shindig.protocol.HttpClientProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.VirtualOrganizationCollectionOptions;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRestDelegationService {
    @Autowired
    private HttpClientProvider httpClientProvider;
    @Autowired
    private ContextEnvironment environment;
    @Autowired
    private ApiCallLogService logService;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected static final String UTF_8 = "UTF-8";

    protected ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    protected InputStream executeHttpGet(String url) throws ClientProtocolException, IOException {
        return this.httpClientProvider.getHttpClient().execute((HttpUriRequest)new HttpGet(url)).getEntity().getContent();
    }

    public void setHttpClientProvider(HttpClientProvider httpClientProvider) {
        this.httpClientProvider = httpClientProvider;
    }

    protected ContextEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ContextEnvironment environment) {
        this.environment = environment;
    }

    protected String getVirtualOrganizationContext(SecurityToken token, CollectionOptions options) {
        OAuthSecurityToken securityToken;
        String voRpc = CoinVoFilter.getVirtualOrganizationContext();
        String virtualOrganization = null;
        if (options != null && options instanceof VirtualOrganizationCollectionOptions) {
            VirtualOrganizationCollectionOptions voOptions = (VirtualOrganizationCollectionOptions)options;
            virtualOrganization = voOptions.getVoName();
        } else if (!StringUtils.isBlank((String)voRpc)) {
            virtualOrganization = voRpc;
        } else if (token instanceof OAuthSecurityToken && !StringUtils.isBlank((String)(securityToken = (OAuthSecurityToken)token).getVirtualOrganization())) {
            virtualOrganization = securityToken.getVirtualOrganization();
        }
        return virtualOrganization;
    }

    protected String getServiceProviderContext(SecurityToken token) {
        String serviceProvider = null;
        if (token instanceof OAuthSecurityToken) {
            serviceProvider = ((OAuthSecurityToken)token).getServiceProviderEntityId();
        }
        return serviceProvider;
    }

    protected void logApiCall(SecurityToken token) {
        String serviceProviderEntityId;
        ApiCallLog log = ApiCallLogContextListener.getApiCallLog();
        log.setApiVersion("SHINDIG");
        if (token instanceof OAuthSecurityToken) {
            OAuthSecurityToken st = (OAuthSecurityToken)token;
            serviceProviderEntityId = st.getServiceProviderEntityId();
            log.setSpEntityId(serviceProviderEntityId);
        } else {
            serviceProviderEntityId = "NO_OAUTH";
        }
        String ownerId = token.getOwnerId();
        if (StringUtils.isBlank((String)ownerId)) {
            ownerId = serviceProviderEntityId;
        }
        log.setUserId(ownerId);
        log.setConsumerKey(token.getAppId());
        this.logService.saveApiCallLog(log);
    }

    public void setLogService(ApiCallLogService logService) {
        this.logService = logService;
    }
}

