/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import nl.surfnet.coin.shindig.model.PersonAppData;
import nl.surfnet.coin.shindig.spi.OpenSocialValidator;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="appDataService")
@Transactional
public class AppDataServiceImpl
implements AppDataService {
    @Autowired
    private OpenSocialValidator openSocialValidator;
    @Autowired
    private SessionFactory sessionFactory;
    private static final String PERSON_APP_DATA = PersonAppData.class.getName();

    public Future<Void> deletePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userId);
        StringBuilder queryString = new StringBuilder("delete from " + PERSON_APP_DATA + " where personId = :personId");
        if (StringUtils.hasText((String)appId)) {
            queryString.append(" and appId = :appId");
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString()).setString("personId", userId.getUserId(token));
        if (StringUtils.hasText((String)appId)) {
            query.setParameter("appId", (Object)appId);
        }
        query.executeUpdate();
        return null;
    }

    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userIds, true);
        List<PersonAppData> result = this.getPersonData(userIds, appId, token);
        return this.constructDataCollection(result);
    }

    private List<PersonAppData> getPersonData(Set<UserId> userIds, String appId, SecurityToken token) {
        StringBuilder queryString = new StringBuilder("from " + PERSON_APP_DATA + " where personId in (:userIds) ");
        if (StringUtils.hasText((String)appId)) {
            queryString.append(" and appId = :appId");
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString());
        query.setParameter("userIds", (Object)userIds.iterator().next().getUserId(token));
        if (StringUtils.hasText((String)appId)) {
            query.setParameter("appId", (Object)appId);
        }
        return query.list();
    }

    private Future<DataCollection> constructDataCollection(List<PersonAppData> result) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        for (PersonAppData personAppData : result) {
            data.put(personAppData.getAppId(), this.cloneData(personAppData.getData()));
        }
        return ImmediateFuture.newInstance((Object)new DataCollection(data));
    }

    private Map<String, String> cloneData(Map<String, String> data) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (data != null) {
            Set<String> keySet = data.keySet();
            for (String key : keySet) {
                result.put(key, data.get(key));
            }
        }
        return result;
    }

    public Future<Void> updatePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, Map<String, String> values, SecurityToken token) throws ProtocolException {
        PersonAppData appData;
        this.openSocialValidator.invariant(userId);
        this.openSocialValidator.invariant(null, null, appId);
        List<PersonAppData> result = this.getPersonData(Collections.singleton(userId), appId, token);
        if (CollectionUtils.isEmpty(result)) {
            appData = new PersonAppData();
            appData.setAppId(appId);
            appData.setData(values);
            appData.setPersonId(userId.getUserId(token));
        } else {
            appData = result.get(0);
            appData.getData().putAll(values);
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)appData);
        return null;
    }

    public void setOpenSocialId(OpenSocialValidator openSocialValidator) {
        this.openSocialValidator = openSocialValidator;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

