/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import nl.surfnet.coin.shindig.protocol.ContextEnvironment;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.MessageCollectionImpl;
import org.apache.shindig.social.core.model.MessageImpl;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="messageService")
@Transactional
public class MessageServiceImpl
implements MessageService {
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private ContextEnvironment environment;
    private static final String MESSAGE = MessageImpl.class.getName();
    private static final String MESSAGE_COLLECTION = MessageCollectionImpl.class.getName();

    public Future<Void> createMessage(UserId userId, String appId, String msgCollId, Message message, SecurityToken token) throws ProtocolException {
        if (StringUtils.hasText((String)msgCollId)) {
            MessageCollection messageCollection = (MessageCollection)this.sessionFactory.getCurrentSession().get(MESSAGE_COLLECTION, (Serializable)((Object)msgCollId));
            if (messageCollection == null) {
                throw new IllegalArgumentException("MessageCollection(ID='" + msgCollId + "') does not exist.");
            }
            List collectionIds = message.getCollectionIds();
            if (collectionIds == null) {
                message.setCollectionIds(new ArrayList());
                collectionIds = message.getCollectionIds();
            }
            if (!collectionIds.contains(msgCollId)) {
                collectionIds.add(msgCollId);
            }
        }
        if (message.getTimeSent() == null) {
            message.setTimeSent(new Date());
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)message);
        return null;
    }

    public Future<MessageCollection> createMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        if (!StringUtils.hasText((String)msgCollection.getTitle())) {
            throw new IllegalArgumentException("Title is mandetory field for MessageCollection");
        }
        MessageCollection singleResult = (MessageCollection)DataAccessUtils.singleResult((Collection)this.sessionFactory.getCurrentSession().createQuery("from " + MESSAGE_COLLECTION + " where title = :title").setString("title", msgCollection.getTitle()).list());
        if (singleResult != null) {
            msgCollection = singleResult;
        } else {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)msgCollection);
        }
        return ImmediateFuture.newInstance((Object)msgCollection);
    }

    public Future<Void> deleteMessageCollection(UserId userId, String msgCollId, SecurityToken token) throws ProtocolException {
        Query query = this.sessionFactory.getCurrentSession().createQuery("delete from " + MESSAGE_COLLECTION + " where id = :id");
        query.setString("id", msgCollId);
        query.executeUpdate();
        return null;
    }

    public Future<Void> deleteMessages(UserId userId, String msgCollId, List<String> ids, SecurityToken token) throws ProtocolException {
        this.deleteMessageCollection(userId, msgCollId, token);
        Query query = this.sessionFactory.getCurrentSession().createQuery("delete from " + MESSAGE + " where id in (:id)");
        query.setParameterList("ids", ids);
        query.executeUpdate();
        return null;
    }

    public Future<RestfulCollection<MessageCollection>> getMessageCollections(UserId userId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        List result = this.sessionFactory.getCurrentSession().createQuery("from " + MESSAGE_COLLECTION).list();
        return ImmediateFuture.newInstance((Object)new RestfulCollection(result));
    }

    public Future<RestfulCollection<Message>> getMessages(UserId userId, String msgCollId, Set<String> fields, List<String> msgIds, CollectionOptions options, SecurityToken token) throws ProtocolException {
        String sortBy = options.getSortBy();
        if (sortBy.equals("topFriends")) {
            sortBy = "timeSent";
        }
        sortBy = sortBy.replaceAll("[^a-zA-Z]", "");
        String sortOrder = options.getSortOrder().toString().equals("ascending") ? "asc" : "desc";
        Query query = StringUtils.hasText((String)msgCollId) ? this.sessionFactory.getCurrentSession().createQuery("from " + MESSAGE + " as mes where :msgCollId in elements(mes.collectionIds) order by " + sortBy + " " + sortOrder).setString("msgCollId", msgCollId) : this.sessionFactory.getCurrentSession().createQuery("from " + MESSAGE + " where id in (:msgIds)").setParameterList("msgIds", msgIds);
        query.setFirstResult(options.getFirst());
        query.setMaxResults(options.getMax());
        return ImmediateFuture.newInstance((Object)new RestfulCollection(query.list()));
    }

    public Future<Void> modifyMessage(UserId userId, String msgCollId, String messageId, Message message, SecurityToken token) throws ProtocolException {
        message.setId(messageId);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)message);
        return null;
    }

    public Future<Void> modifyMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)msgCollection);
        return null;
    }

    public void setEnvironment(ContextEnvironment environment) {
        this.environment = environment;
    }
}

