/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.Collection;
import nl.surfnet.coin.shindig.spi.OAuthEntryService;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="oAuthEntryService")
@Transactional
public class OAuthEntryServiceImpl
implements OAuthEntryService {
    @Autowired
    private SessionFactory sessionFactory;
    private static final String OAUTH_ENTRY = OAuthEntry.class.getName();

    @Override
    public OAuthEntry getOAuthEntry(String oauthToken) {
        Criteria crit = this.sessionFactory.getCurrentSession().createCriteria(OAUTH_ENTRY);
        crit.add((Criterion)Restrictions.eq((String)"token", (Object)oauthToken));
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return (OAuthEntry)DataAccessUtils.singleResult((Collection)crit.list());
    }

    @Override
    public void saveOAuthEntry(OAuthEntry oauthEntry) {
        this.sessionFactory.getCurrentSession().saveOrUpdate(OAUTH_ENTRY, (Object)oauthEntry);
    }

    @Override
    public void deleteOAuthEntry(String oauthToken) {
        OAuthEntry oauthEntry = this.getOAuthEntry(oauthToken);
        if (oauthEntry != null) {
            this.sessionFactory.getCurrentSession().delete(OAUTH_ENTRY, (Object)oauthEntry);
        }
    }
}

