/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.shindig.spi;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nl.surfnet.coin.shared.domain.ErrorMail;
import nl.surfnet.coin.shared.service.ErrorMessageMailer;
import nl.surfnet.coin.shindig.spi.AbstractRestDelegationService;
import nl.surfnet.coin.shindig.spi.OpenSocialValidator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.AccountImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.OrganizationImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="personService")
public class PersonServiceImpl
extends AbstractRestDelegationService
implements PersonService {
    private static final String PERSON_URL = "/social/people/";
    @Autowired
    private ErrorMessageMailer errorMessageMailer;
    @Autowired
    private GroupService groupService;
    @Autowired
    private OpenSocialValidator openSocialValidator;

    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, SecurityToken token) throws ProtocolException {
        this.openSocialValidator.invariant(userIds, groupId);
        String onBehalfOf = token != null ? token.getOwnerId() : null;
        try {
            this.logApiCall(token);
            return this.doGetPeople(userIds, groupId, fields, token, collectionOptions, onBehalfOf);
        }
        catch (Exception e) {
            String shortMessage = "Exception in getPeople for user(id='" + onBehalfOf + "')";
            String errorMessage = "An exception occured in the PersonService in the Shindig server<br/>connecting to the EngineBlock PHP endpoint:" + e.getMessage() + "<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMail = new ErrorMail(shortMessage, errorMessage, onBehalfOf, e.getMessage(), this.getHost(), "Shindig");
            errorMail.setLocation(this.getClass().getName() + "#getPeople");
            this.errorMessageMailer.sendErrorMail(errorMail);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    private Future<RestfulCollection<Person>> doGetPeople(Set<UserId> userIds, GroupId groupId, Set<String> fields, SecurityToken token, CollectionOptions collectionOptions, String onBehalfOf) throws IOException, InterruptedException, ExecutionException {
        List<Object> persons = new ArrayList();
        if (groupId == null) {
            if (userIds.size() > 1) {
                String idsOfUser = StringUtils.join(userIds, (String)",");
                persons = this.doGetPersons(idsOfUser, null, token, collectionOptions, onBehalfOf);
            } else {
                Future<Person> person = this.getPerson(userIds.iterator().next(), fields, token);
                persons = Collections.singletonList(person.get());
            }
        } else {
            persons = this.doGetPersons(userIds.iterator().next().getUserId(token), groupId.getGroupId(), token, collectionOptions, onBehalfOf);
        }
        return this.createFutureForPersons(persons);
    }

    private Future<RestfulCollection<Person>> createFutureForPersons(List<Person> persons) {
        if (persons == null) {
            persons = new ArrayList<Person>();
        }
        return ImmediateFuture.newInstance((Object)new RestfulCollection(persons));
    }

    public Future<Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            String idOfUser = id.getUserId(token);
            String onBehalfOf = token != null ? token.getOwnerId() : null;
            List<Person> persons = this.doGetPersons(idOfUser, null, token, null, onBehalfOf);
            Person person = persons == null || persons.size() == 0 ? null : persons.get(0);
            this.logApiCall(token);
            return ImmediateFuture.newInstance((Object)person);
        }
        catch (Exception e) {
            String shortMessage = "Exception in getPerson(id='" + id.getUserId(token) + "')";
            String errorMessage = "An exception occured in the PersonService in the Shindig server\nconnecting to the EngineBlock PHP endpoint:<br/><br/>" + this.getClass().getSimpleName() + "<br/>" + shortMessage;
            ErrorMail errorMailDetails = new ErrorMail(shortMessage, errorMessage, id.getUserId(token), e.getMessage(), this.getHost(), "Shindig");
            this.errorMessageMailer.sendErrorMail(errorMailDetails);
            throw new RuntimeException(shortMessage, e);
        }
    }

    private List<Person> doGetPersons(String formattedIds, String groupId, SecurityToken securityToken, CollectionOptions collectionOptions, String onBehalfOf) throws IOException, InterruptedException, ExecutionException {
        String virtualOrganizationContext;
        boolean subjectIsNotOwner;
        StringBuilder url = new StringBuilder(this.getEnvironment().getBaseSocialApiUrl());
        url.append(PERSON_URL);
        boolean bl = subjectIsNotOwner = org.springframework.util.StringUtils.hasText((String)onBehalfOf) && !formattedIds.equals(onBehalfOf);
        if (subjectIsNotOwner) {
            this.checkIdentitySecurity(onBehalfOf, formattedIds, securityToken);
            url.append(URLEncoder.encode(onBehalfOf, "UTF-8"));
        } else {
            url.append(URLEncoder.encode(formattedIds, "UTF-8"));
        }
        if (org.springframework.util.StringUtils.hasText((String)groupId)) {
            url.append("/");
            url.append(URLEncoder.encode(groupId, "UTF-8"));
        }
        url.append("?fields=all");
        String serviceProviderContext = super.getServiceProviderContext(securityToken);
        if (org.springframework.util.StringUtils.hasText((String)serviceProviderContext)) {
            url.append("&sp-entity-id=" + URLEncoder.encode(serviceProviderContext, "UTF-8"));
        }
        if (org.springframework.util.StringUtils.hasText((String)(virtualOrganizationContext = super.getVirtualOrganizationContext(securityToken, collectionOptions)))) {
            url.append("&vo=" + URLEncoder.encode(virtualOrganizationContext, "UTF-8"));
        }
        if (subjectIsNotOwner) {
            url.append("&subject-id=" + URLEncoder.encode(formattedIds, "UTF-8"));
        }
        InputStream inputStream = this.executeHttpGet(url.toString());
        List<Person> persons = this.constructPersons(inputStream, virtualOrganizationContext);
        inputStream.close();
        if (org.springframework.util.StringUtils.hasText((String)groupId) && org.springframework.util.StringUtils.hasText((String)onBehalfOf)) {
            this.checkIdentitySecurityGroup(groupId, onBehalfOf, persons);
        }
        return persons;
    }

    private void checkIdentitySecurityGroup(String groupId, String onBehalfOf, List<Person> persons) {
        if (persons != null) {
            for (Person person : persons) {
                if (!person.getId().equals(onBehalfOf)) continue;
                return;
            }
        }
        throw new IllegalArgumentException("Requested members retrieval for " + groupId + " is not granted, as " + onBehalfOf + " is not a member");
    }

    private void checkIdentitySecurity(String onBehalfOf, String personId, SecurityToken token) throws InterruptedException, ExecutionException, IOException {
        List personIdGroups = ((RestfulCollection)this.groupService.getGroups(new UserId(UserId.Type.userId, personId), null, null, this.getSecureToken(personId, token)).get()).getEntry();
        List onBehalfOfGroups = ((RestfulCollection)this.groupService.getGroups(new UserId(UserId.Type.userId, onBehalfOf), null, null, this.getSecureToken(onBehalfOf, token)).get()).getEntry();
        HashSet merged = new HashSet(personIdGroups);
        merged.addAll(onBehalfOfGroups);
        int personGroupsSize = personIdGroups.size();
        int onBehalfOfGroupsSize = onBehalfOfGroups.size();
        int mergedSize = merged.size();
        if (personGroupsSize + onBehalfOfGroupsSize == mergedSize) {
            throw new IllegalArgumentException("Requested person retrieval for " + personId + " is not granted, as " + onBehalfOf + " does not share a teammembership");
        }
    }

    private SecurityToken getSecureToken(String personId, SecurityToken token) {
        if (token instanceof OAuthSecurityToken) {
            OAuthSecurityToken oauthToken = (OAuthSecurityToken)token;
            return new OAuthSecurityToken(personId, token.getAppUrl(), token.getAppId(), token.getDomain(), token.getDomain(), token.getExpiresAt(), oauthToken.getVirtualOrganization(), oauthToken.getServiceProviderEntityId());
        }
        return new OAuthSecurityToken(personId, token.getAppUrl(), token.getAppId(), token.getDomain(), token.getDomain(), token.getExpiresAt(), null, null);
    }

    private List<Person> constructPersons(InputStream inputStream, String virtualOrganizationContext) throws IOException {
        String json = null;
        try {
            List l;
            json = IOUtils.toString((InputStream)inputStream);
            HashMap result = (HashMap)this.getObjectMapper().readValue(json, HashMap.class);
            List entries = (List)result.get("entry");
            if (CollectionUtils.isEmpty((Collection)entries) || this.isEmptyListOfList(entries)) {
                return null;
            }
            ArrayList<Person> persons = new ArrayList<Person>();
            List entry = entries.get(0) instanceof List ? (l = (List)entries.get(0)) : entries;
            for (Map personMap : entry) {
                Object tagsListWrapper;
                Object extensionsMapWrapper;
                Object accountMapWrapper;
                Object nameMapWrapper;
                Object organizationMapWrapper;
                PersonImpl person = new PersonImpl();
                person.setId((String)personMap.get("id"));
                person.setNickname((String)personMap.get("nickname"));
                person.setDisplayName((String)personMap.get("displayName"));
                person.setVoot_membership_role((String)personMap.get("voot_membership_role"));
                List emailList = (List)personMap.get("emails");
                if (!CollectionUtils.isEmpty((Collection)emailList)) {
                    ArrayList<ListFieldImpl> emails = new ArrayList<ListFieldImpl>();
                    for (String email : emailList) {
                        emails.add(new ListFieldImpl("email", email));
                    }
                    person.setEmails(emails);
                }
                if ((organizationMapWrapper = personMap.get("organizations")) instanceof Map && !CollectionUtils.isEmpty((Map)((Map)organizationMapWrapper))) {
                    Map organizationMap = (Map)organizationMapWrapper;
                    ArrayList<OrganizationImpl> organizations = new ArrayList<OrganizationImpl>();
                    OrganizationImpl organization = new OrganizationImpl();
                    organization.setName((String)organizationMap.get("name"));
                    organizations.add(organization);
                    person.setOrganizations(organizations);
                }
                if ((nameMapWrapper = personMap.get("name")) instanceof Map && !CollectionUtils.isEmpty((Map)((Map)nameMapWrapper))) {
                    Map nameMap = (Map)nameMapWrapper;
                    NameImpl name = new NameImpl();
                    name.setFormatted((String)nameMap.get("formatted"));
                    name.setGivenName((String)nameMap.get("givenName"));
                    name.setFamilyName((String)nameMap.get("familyName"));
                    person.setName((Name)name);
                }
                if ((accountMapWrapper = personMap.get("account")) instanceof Map && !CollectionUtils.isEmpty((Map)((Map)accountMapWrapper))) {
                    Map accountMap = (Map)personMap.get("account");
                    ArrayList<AccountImpl> accounts = new ArrayList<AccountImpl>();
                    accounts.add(new AccountImpl((String)accountMap.get("domain"), (String)accountMap.get("userId"), (String)accountMap.get("username")));
                    person.setAccounts(accounts);
                }
                if ((extensionsMapWrapper = personMap.get(virtualOrganizationContext)) instanceof List && !CollectionUtils.isEmpty((Map)((Map)extensionsMapWrapper))) {
                    List extensionsMap = (List)extensionsMapWrapper;
                    HashMap<String, String> extensions = new HashMap<String, String>();
                    for (Object object : extensionsMap) {
                        Map map = (Map)object;
                        Map keyValue = (Map)map.get("entry");
                        String key = (String)keyValue.get("key");
                        String value = "";
                        for (String val : (ArrayList)keyValue.get("value")) {
                            value = value + val + ", ";
                        }
                        value = StringUtils.removeEnd((String)value.trim(), (String)",");
                        extensions.put(key, value);
                    }
                    person.setExtensions(extensions);
                }
                if ((tagsListWrapper = personMap.get("tags")) instanceof List && !CollectionUtils.isEmpty((Collection)((List)tagsListWrapper))) {
                    List tagsList = (List)tagsListWrapper;
                    person.setTags(tagsList);
                }
                persons.add((Person)person);
            }
            return persons;
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            String errorMessage = "Error parsing Person JSON: " + json;
            throw new RuntimeException(errorMessage, e);
        }
    }

    private boolean isEmptyListOfList(List entries) {
        return entries.get(0) instanceof List && ((List)entries.get(0)).size() == 0;
    }

    public void setOpenSocialId(OpenSocialValidator openSocialValidator) {
        this.openSocialValidator = openSocialValidator;
    }

    public void setErrorMessageMailer(ErrorMessageMailer errorMessageMailer) {
        this.errorMessageMailer = errorMessageMailer;
    }

    protected void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }
}

