/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.oauth;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;

import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.OAuthStore;

/**
 * 
 * Replacement for the {@link OAuthModule} . We can't extend {@link OAuthModule} and call
 * super.configure, because Guice does not permit bindig the same thing twice.
 * Therefore some duplicate code, but at least no changes in {@link OAuthModule}
 *
 */
public class CoinOAuthModule extends AbstractModule {

  @Override
  protected void configure() {
    bind(BlobCrypter.class).annotatedWith(Names.named(OAuthFetcherConfig.OAUTH_STATE_CRYPTER))
        .toProvider(OAuthModule.OAuthCrypterProvider.class);
    bind(OAuthStore.class).toProvider(CoinOAuthStoreProvider.class);
    bind(OAuthRequest.class).toProvider(OAuthModule.OAuthRequestProvider.class);
    
  }

}
