/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.oauth;

import java.io.Serializable;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.oauth.OAuthStore.TokenInfo;

/**
 * 
 * Domain object to store {@link TokenInfo} objects in the database
 *
 */
@SuppressWarnings("serial")
public class CoinOAuthTokenInfo implements Serializable{

  //see OAuthSecurityToken#getModuleId
  public static final String MODULE_ID = "NOT_USED";
  
  private String id;
  private String accessToken;
  private String tokenSecret;
  private String sessionHandle;
  private long tokenExpireMillis;
  
  private String appUrl;
  private String moduleId;
  private String serviceName;
  private String tokenName;
  private String userId;
  
  public CoinOAuthTokenInfo() {
    super();
    
  }
  public CoinOAuthTokenInfo(SecurityToken securityToken, String serviceName,
      String tokenName, TokenInfo tokenInfo) {
    this.setAccessToken(tokenInfo.getAccessToken());
    this.setAppUrl(securityToken.getAppUrl());
    this.setModuleId(MODULE_ID);
    this.setServiceName(serviceName);
    this.setSessionHandle(tokenInfo.getSessionHandle());
    this.setTokenExpireMillis(tokenInfo.getTokenExpireMillis());
    this.setTokenName(tokenName);
    this.setTokenSecret(tokenInfo.getTokenSecret());
    this.setUserId(securityToken.getViewerId());
  }
  /**
   * @return the id
   */
  public String getId() {
    return id;
  }
  /**
   * @param id the id to set
   */
  public void setId(String id) {
    this.id = id;
  }
  /**
   * @return the accessToken
   */
  public String getAccessToken() {
    return accessToken;
  }
  /**
   * @param accessToken the accessToken to set
   */
  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }
  /**
   * @return the tokenSecret
   */
  public String getTokenSecret() {
    return tokenSecret;
  }
  /**
   * @param tokenSecret the tokenSecret to set
   */
  public void setTokenSecret(String tokenSecret) {
    this.tokenSecret = tokenSecret;
  }
  /**
   * @return the sessionHandle
   */
  public String getSessionHandle() {
    return sessionHandle;
  }
  /**
   * @param sessionHandle the sessionHandle to set
   */
  public void setSessionHandle(String sessionHandle) {
    this.sessionHandle = sessionHandle;
  }
  /**
   * @return the tokenExpireMillis
   */
  public long getTokenExpireMillis() {
    return tokenExpireMillis;
  }
  /**
   * @param tokenExpireMillis the tokenExpireMillis to set
   */
  public void setTokenExpireMillis(long tokenExpireMillis) {
    this.tokenExpireMillis = tokenExpireMillis;
  }
  /**
   * @return the appUrl
   */
  public String getAppUrl() {
    return appUrl;
  }
  /**
   * @param appUrl the appUrl to set
   */
  public void setAppUrl(String appUrl) {
    this.appUrl = appUrl;
  }
  /**
   * @return the moduleId
   */
  public String getModuleId() {
    return moduleId;
  }
  /**
   * @param moduleId the moduleId to set
   */
  public void setModuleId(String moduleId) {
    this.moduleId = moduleId;
  }
  /**
   * @return the serviceName
   */
  public String getServiceName() {
    return serviceName;
  }
  /**
   * @param serviceName the serviceName to set
   */
  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }
  /**
   * @return the tokenName
   */
  public String getTokenName() {
    return tokenName;
  }
  /**
   * @param tokenName the tokenName to set
   */
  public void setTokenName(String tokenName) {
    this.tokenName = tokenName;
  }
  /**
   * @return the userId
   */
  public String getUserId() {
    return userId;
  }
  /**
   * @param userId the userId to set
   */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
