/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.shindig.oauth;

import java.io.IOException;
import java.net.URLEncoder;

import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.servlet.InjectedFilter;

/**
 * Responsible for rewriting the URL: grabbing the vo part and turning this into
 * a query parameter
 * 
 */
public class CoinVoFilter extends InjectedFilter {

  private static final ThreadLocal<String> VIRTUAL_ORGANIZATION_CONTEXT = new ThreadLocal<String>();

  /**
   * The prefix for Virtual Organizations context specific behavior
   */
  private static final String VO_PREFIX = "/vo/";

  /*
   * (non-Javadoc)
   * 
   * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
   * javax.servlet.ServletResponse, javax.servlet.FilterChain)
   */
  @Override
  public void doFilter(ServletRequest request, ServletResponse response,
      FilterChain chain) throws IOException, ServletException {
    try {
      doForward(request, response);
    } catch (Exception e) {
      // if someone is screwing around we just proceed as normal
      chain.doFilter(request, response);
    }

  }

  private void doForward(ServletRequest request, ServletResponse response)
      throws ServletException, IOException {
    HttpServletRequest req = (HttpServletRequest) request;
    HttpServletResponse res = (HttpServletResponse) response;
    String requestURI = req.getRequestURI();
    String vo = requestURI.substring(VO_PREFIX.length(),
        requestURI.indexOf("/", VO_PREFIX.length()));
    vo = URLEncoder.encode(vo, "UTF-8");
    VIRTUAL_ORGANIZATION_CONTEXT.set(vo);
    String queryString = req.getQueryString();
    queryString = (StringUtils.isBlank(queryString) ? "" : (queryString +"&"));
    String newPath = requestURI.substring(VO_PREFIX.length() + vo.length())
        + "?" + queryString + "vo=" + vo;
//    if (newPath.toUpperCase().contains("LOGIN") || newPath.toUpperCase().contains("OAUTH")){ 
//      res.sendRedirect(newPath);
//    } else {
      RequestDispatcher requestDispatcher = req.getRequestDispatcher(newPath);
      requestDispatcher.forward(request, response);
 //   }
  }

  /*
   * (non-Javadoc)
   * 
   * @see javax.servlet.Filter#destroy()
   */
  @Override
  public void destroy() {
  }

  /**
   * Non-idempotent getter for the VO context.
   * 
   * @return the virtual organization name (if nay)
   */
  public static String getVirtualOrganizationContext() {
    String result = VIRTUAL_ORGANIZATION_CONTEXT.get();
    VIRTUAL_ORGANIZATION_CONTEXT.set(null);
    return result;
  }

}
