/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.protocol;

/**
 * Provides information about the context of the application/environement
 */
public class ContextEnvironment {

  /*
   * URL for the EngineBlock endpoint
   */
  private String baseSocialApiUrl;

  /*
   * Are we running in dummyMode (using the shindig json persistent store)
   */
  private boolean dummyMode;

  /*
   * Name (local, dev, test, acc, prod) of the JavaScript container
   */
  private String containerName;
  
  /*
   * Is the postProcessing enabled for activities and messages
   */
  private boolean messagePostprocessingEnabled;

  /*
   * Shibboleth authentication url suffix, used for shindig authentication
   */
  private String shibbolethAuthenticationUrlSuffix;

  /*
   * Shindig base URL
   */
  private String shindigBaseUrl;
  
  /*
   * Dummy user for shib login
   */
  private String shibbolethDummyUser;
  
  /*
   * The entityID prefix for redirecting to vo login
   */
  private String voMetadataPrefix;
  

  /**
   * @return the baseSocialApiUrl
   */
  public String getBaseSocialApiUrl() {
    return baseSocialApiUrl;
  }

  /**
   * @param baseSocialApiUrl
   *          the baseSocialApiUrl to set
   */
  public void setBaseSocialApiUrl(String baseSocialApiUrl) {
    this.baseSocialApiUrl = baseSocialApiUrl;
  }

  /**
   * @return the dummyMode
   */
  public boolean isDummyMode() {
    return dummyMode;
  }

  /**
   * @param dummyMode
   *          the dummyMode to set
   */
  public void setDummyMode(boolean dummyMode) {
    this.dummyMode = dummyMode;
  }

  public String getContainerName() {
    return containerName;
  }

  /**
   * @param shibbolethAuthenticationUrlSuffix
   *          the shibbolethAuthenticationUrlSuffix to set
   */
  public void setShibbolethAuthenticationUrlSuffix(
      String shibbolethAuthenticationUrlSuffix) {
    this.shibbolethAuthenticationUrlSuffix = shibbolethAuthenticationUrlSuffix;
  }

  /**
   * @return the shibbolethAuthenticationUrlSuffix
   */
  public String getShibbolethAuthenticationUrlSuffix() {
    return shibbolethAuthenticationUrlSuffix;
  }

  /**
   * @param shindigBaseUrl
   *          the shindigBaseUrl to set
   */
  public void setShindigBaseUrl(String shindigBaseUrl) {
    this.shindigBaseUrl = shindigBaseUrl;
  }

  /**
   * @return the shindigBaseUrl
   */
  public String getShindigBaseUrl() {
    return shindigBaseUrl;
  }

  /**
   * @return the messagePostprocessingEnabled
   */
  public boolean isMessagePostprocessingEnabled() {
    return messagePostprocessingEnabled;
  }

  /**
   * @param messagePostprocessingEnabled the messagePostprocessingEnabled to set
   */
  public void setMessagePostprocessingEnabled(boolean messagePostprocessingEnabled) {
    this.messagePostprocessingEnabled = messagePostprocessingEnabled;
  }

  /**
   * @return the shibbolethDummyUser
   */
  public String getShibbolethDummyUser() {
    return shibbolethDummyUser;
  }

  /**
   * @param shibbolethDummyUser the shibbolethDummyUser to set
   */
  public void setShibbolethDummyUser(String shibbolethDummyUser) {
    this.shibbolethDummyUser = shibbolethDummyUser;
  }

  /**
   * @return the voMetadataPrefix
   */
  public String getVoMetadataPrefix() {
    return voMetadataPrefix;
  }

  /**
   * @param voMetadataPrefix the voMetadataPrefix to set
   */
  public void setVoMetadataPrefix(String voMetadataPrefix) {
    this.voMetadataPrefix = voMetadataPrefix;
  }
}
