/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nl.surfnet.coin.shindig.protocol;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.util.Properties;

/**
 * Injects everything from the a property file as a Named value Uses the
 * coin-shindig.properties file
 */
public class DiyPropertiesModule extends AbstractModule {

  private final static String PROPERTIES_FILE = "coin-shindig-diy.properties";

  private final Properties properties;

  public DiyPropertiesModule() throws IOException {
    super();
    this.properties = new Properties();
    this.properties.load(new ClassPathResource(PROPERTIES_FILE)
        .getInputStream());
  }

  @Override
  protected void configure() {
    Names.bindProperties(this.binder(), this.properties);
  }
}
