/*
 * Copyright 2011 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.surfnet.coin.shindig.spi;

import java.util.List;

import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.spi.ActivityService;

/**
 * This interface is an extension on the shinding {@link ActivityService}. It
 * defines functionality needed by the coin portal as the current interface does
 * not allow for searching on multiple groups. Note that this interface can't be
 * used by gadgets; it purpose is to aid the functionality of the coin portal.
 * 
 */
public interface CoinActivityService {

  /**
   * Find {@link Activity} sorted on date by Group
   * 
   * @param group
   *          the {@link Group} for the result
   * @param maxResult
   *          the number of maximum returned {@link Activity}
   * @param firstRessults
   *          the number of activities to skip
   * @return
   */
  List<Activity> findActivityByGroups(Group group, int maxResult,
      int firstRessults);

}
