/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package nl.surfnet.coin.shindig.spi;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletRequestEvent;

import nl.surfnet.coin.shared.log.ApiCallLog;
import nl.surfnet.coin.shared.log.ApiCallLogContextListener;
import nl.surfnet.coin.shared.log.ApiCallLogService;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockServletContext;

/**
 * 
 *
 */
public class ApiCallLogServiceMock implements ApiCallLogService {

  
  
  public ApiCallLogServiceMock() {
    super();
    init();
  }

  private void init() {
    ApiCallLogContextListener listener = new ApiCallLogContextListener();
    ServletRequestEvent requestEvent = new ServletRequestEvent(new MockServletContext(), new MockHttpServletRequest(
        "GET", "http://127.0.0.1/social/people/test"));
    listener.requestInitialized(requestEvent);
  }
  

  /* (non-Javadoc)
   * @see nl.surfnet.coin.shared.log.ApiCallLogService#saveApiCallLog(nl.surfnet.coin.shared.log.ApiCallLog)
   */
  @Override
  public void saveApiCallLog(ApiCallLog log) {
    //do nothing
    
  }

  /* (non-Javadoc)
   * @see nl.surfnet.coin.shared.log.ApiCallLogService#findApiCallLog(java.lang.String)
   */
  @Override
  public List<ApiCallLog> findApiCallLog(String serviceProvider) {
   return new ArrayList<ApiCallLog>();
  }

  /* (non-Javadoc)
   * @see nl.surfnet.coin.shared.log.ApiCallLogService#findServiceProviders()
   */
  @Override
  public List<String> findServiceProviders() {
    return new ArrayList<String>();
  }

}
